/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.registry.Registry;
import java.io.IOException;

public class AuthenticatorDataDeserializer
extends StdDeserializer<AuthenticatorData> {
    private final transient AuthenticatorDataConverter authenticatorDataConverter;

    public AuthenticatorDataDeserializer(Registry registry) {
        super(AuthenticatorData.class);
        this.authenticatorDataConverter = new AuthenticatorDataConverter(registry);
    }

    public AuthenticatorData deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        return this.authenticatorDataConverter.convert(value);
    }
}

