/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.attestation.AttestationObject;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.registry.Registry;
import com.webauthn4j.util.Base64UrlUtil;
import java.io.IOException;
import java.io.UncheckedIOException;

public class AttestationObjectConverter {
    private CborConverter cborConverter;

    public AttestationObjectConverter(Registry registry) {
        this.cborConverter = new CborConverter(registry.getCborMapper());
    }

    public AttestationObject convert(String source) {
        byte[] value = Base64UrlUtil.decode((String)source);
        return this.convert(value);
    }

    public AttestationObject convert(byte[] source) {
        return (AttestationObject)this.cborConverter.readValue(source, AttestationObject.class);
    }

    public byte[] convertToBytes(AttestationObject source) {
        return this.cborConverter.writeValueAsBytes(source);
    }

    public String convertToString(AttestationObject source) {
        byte[] bytes = this.convertToBytes(source);
        return Base64UrlUtil.encodeToString((byte[])bytes);
    }

    public byte[] extractAuthenticatorData(byte[] attestationObject) {
        try {
            return this.cborConverter.readTree(attestationObject).get("authData").binaryValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

