/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.client;

import java.io.Serializable;
import java.net.URI;

public class Origin
implements Serializable {
    private static final String SCHEME_HTTPS = "https";
    private static final String SCHEME_HTTP = "http";
    private String scheme;
    private String host;
    private int port;

    public Origin(String scheme, String host, int port) {
        if (!scheme.equals(SCHEME_HTTPS) && !scheme.equals(SCHEME_HTTP)) {
            throw new IllegalArgumentException("scheme must be 'http' or 'https'");
        }
        this.scheme = scheme;
        this.host = host;
        this.port = port;
    }

    public Origin(String originUrl) {
        URI uri = URI.create(originUrl);
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        int originPort = uri.getPort();
        if (originPort == -1) {
            switch (this.scheme) {
                case "https": {
                    originPort = 443;
                    break;
                }
                case "http": {
                    originPort = 80;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("scheme must be 'http' or 'https'");
                }
            }
        }
        this.port = originPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        String result = this.scheme + "://" + this.host;
        switch (this.scheme) {
            case "https": {
                if (this.port == 443) break;
                result = result + ":" + this.port;
                break;
            }
            case "http": {
                if (this.port == 80) break;
                result = result + ":" + this.port;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Origin)) {
            return false;
        }
        Origin origin = (Origin)o;
        if (this.port != origin.port) {
            return false;
        }
        if (!this.scheme.equals(origin.scheme)) {
            return false;
        }
        return this.host.equals(origin.host);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }
}

