/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.extension.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.extension.client.AbstractClientExtensionOutput;
import java.io.Serializable;
import java.util.Objects;

public class BiometricAuthenticatorPerformanceBoundsClientExtensionOutput
extends AbstractClientExtensionOutput<AuthenticatorBiometricPerfBounds> {
    public static final String ID = "biometricPerfBounds";

    @JsonCreator
    public BiometricAuthenticatorPerformanceBoundsClientExtensionOutput(AuthenticatorBiometricPerfBounds value) {
        super(value);
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    public static class AuthenticatorBiometricPerfBounds
    implements Serializable {
        private float FAR;
        private float FRR;

        public AuthenticatorBiometricPerfBounds(float FAR, float FRR) {
            this.FAR = FAR;
            this.FRR = FRR;
        }

        public AuthenticatorBiometricPerfBounds() {
        }

        public float getFAR() {
            return this.FAR;
        }

        public float getFRR() {
            return this.FRR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthenticatorBiometricPerfBounds that = (AuthenticatorBiometricPerfBounds)o;
            return Float.compare(that.FAR, this.FAR) == 0 && Float.compare(that.FRR, this.FRR) == 0;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.FAR), Float.valueOf(this.FRR));
        }
    }
}

