/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.extension.authneticator.AuthenticatorExtensionOutput;
import com.webauthn4j.extension.authneticator.GenericTransactionAuthorizationAuthenticatorExtensionOutput;
import com.webauthn4j.extension.authneticator.LocationAuthenticatorExtensionOutput;
import com.webauthn4j.extension.authneticator.SimpleTransactionAuthorizationAuthenticatorExtensionOutput;
import com.webauthn4j.extension.authneticator.SupportedExtensionsAuthenticatorExtensionOutput;
import com.webauthn4j.extension.authneticator.UserVerificationIndexAuthenticatorExtensionOutput;
import com.webauthn4j.util.exception.NotImplementedException;
import java.io.IOException;

public class AuthenticatorExtensionOutputDeserializer
extends StdDeserializer<AuthenticatorExtensionOutput> {
    public AuthenticatorExtensionOutputDeserializer() {
        super(AuthenticatorExtensionOutput.class);
    }

    public AuthenticatorExtensionOutput deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String currentName = p.getParsingContext().getCurrentName();
        if ("txAuthSimple".equals(currentName)) {
            return (AuthenticatorExtensionOutput)ctxt.readValue(p, SimpleTransactionAuthorizationAuthenticatorExtensionOutput.class);
        }
        if ("uvi".equals(currentName)) {
            return (AuthenticatorExtensionOutput)ctxt.readValue(p, UserVerificationIndexAuthenticatorExtensionOutput.class);
        }
        String parentName = p.getParsingContext().getParent().getCurrentName();
        if ("txAuthGeneric".equals(parentName)) {
            return (AuthenticatorExtensionOutput)ctxt.readValue(p, GenericTransactionAuthorizationAuthenticatorExtensionOutput.class);
        }
        if ("exts".equals(parentName)) {
            return (AuthenticatorExtensionOutput)ctxt.readValue(p, SupportedExtensionsAuthenticatorExtensionOutput.class);
        }
        if ("loc".equals(parentName)) {
            return (AuthenticatorExtensionOutput)ctxt.readValue(p, LocationAuthenticatorExtensionOutput.class);
        }
        if ("uvi".equals(parentName)) {
            return (AuthenticatorExtensionOutput)ctxt.readValue(p, UserVerificationIndexAuthenticatorExtensionOutput.class);
        }
        throw new NotImplementedException();
    }
}

