/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.WebAuthnRegistrationContext;
import com.webauthn4j.attestation.AttestationObject;
import com.webauthn4j.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.attestation.statement.AttestationStatement;
import com.webauthn4j.attestation.statement.AttestationType;
import com.webauthn4j.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.client.CollectedClientData;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.exception.NotImplementedException;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.ChallengeValidator;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.TokenBindingValidator;
import com.webauthn4j.validator.attestation.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.fido.NullFIDOU2FAttestationStatementValidator;
import com.webauthn4j.validator.attestation.none.NoneAttestationStatementValidator;
import com.webauthn4j.validator.attestation.packed.NullPackedAttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.ECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.NullECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.DefaultSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.BadAttestationStatementException;
import com.webauthn4j.validator.exception.MaliciousDataException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class WebAuthnRegistrationContextValidator {
    private final List<AttestationStatementValidator> attestationStatementValidators;
    private final CertPathTrustworthinessValidator certPathTrustworthinessValidator;
    private final ECDAATrustworthinessValidator ecdaaTrustworthinessValidator;
    private final SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator;
    private final ChallengeValidator challengeValidator = new ChallengeValidator();
    private final OriginValidator originValidator = new OriginValidator();
    private final TokenBindingValidator tokenBindingValidator = new TokenBindingValidator();
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final CollectedClientDataConverter collectedClientDataConverter = new CollectedClientDataConverter();
    private final AttestationObjectConverter attestationObjectConverter = new AttestationObjectConverter();

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator) {
        AssertUtil.notNull(attestationStatementValidators, (String)"attestationStatementValidators must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessValidator, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)ecdaaTrustworthinessValidator, (String)"ecdaaTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessValidator, (String)"selfAttestationTrustworthinessValidator must not be null");
        this.attestationStatementValidators = attestationStatementValidators;
        this.certPathTrustworthinessValidator = certPathTrustworthinessValidator;
        this.ecdaaTrustworthinessValidator = ecdaaTrustworthinessValidator;
        this.selfAttestationTrustworthinessValidator = selfAttestationTrustworthinessValidator;
    }

    public WebAuthnRegistrationContextValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, new DefaultSelfAttestationTrustworthinessValidator());
    }

    public static WebAuthnRegistrationContextValidator createNullAttestationStatementValidator() {
        return new WebAuthnRegistrationContextValidator(Arrays.asList(new NoneAttestationStatementValidator(), new NullFIDOU2FAttestationStatementValidator(), new NullPackedAttestationStatementValidator()), new NullCertPathTrustworthinessValidator(), new NullECDAATrustworthinessValidator(), new NullSelfAttestationTrustworthinessValidator());
    }

    public void validate(WebAuthnRegistrationContext registrationContext) {
        BeanAssertUtil.validate(registrationContext);
        byte[] clientDataBytes = registrationContext.getCollectedClientData();
        byte[] attestationObjectBytes = registrationContext.getAttestationObject();
        CollectedClientData collectedClientData = this.collectedClientDataConverter.convert(clientDataBytes);
        AttestationObject attestationObject = this.attestationObjectConverter.convert(attestationObjectBytes);
        BeanAssertUtil.validate(collectedClientData);
        BeanAssertUtil.validate(attestationObject);
        RegistrationObject registrationObject = new RegistrationObject(collectedClientData, clientDataBytes, attestationObject, attestationObjectBytes, registrationContext.getServerProperty());
        AuthenticatorData authenticatorData = attestationObject.getAuthenticatorData();
        ServerProperty serverProperty = registrationContext.getServerProperty();
        if (!Objects.equals(collectedClientData.getType(), "webauthn.create")) {
            throw new MaliciousDataException("Bad client data type");
        }
        this.challengeValidator.validate(collectedClientData, serverProperty);
        this.originValidator.validate(collectedClientData, serverProperty);
        this.tokenBindingValidator.validate(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        AttestationType attestationType = this.validateAttestationStatement(registrationObject);
        AttestationStatement attestationStatement = attestationObject.getAttestationStatement();
        switch (attestationType) {
            case SELF: {
                if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                    CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                    this.selfAttestationTrustworthinessValidator.validate(certificateBaseAttestationStatement);
                    break;
                }
                throw new IllegalStateException();
            }
            case ECDAA: {
                this.ecdaaTrustworthinessValidator.validate(attestationStatement);
                break;
            }
            case BASIC: 
            case ATT_CA: {
                if (attestationStatement instanceof CertificateBaseAttestationStatement) {
                    CertificateBaseAttestationStatement certificateBaseAttestationStatement = (CertificateBaseAttestationStatement)attestationStatement;
                    this.certPathTrustworthinessValidator.validate(certificateBaseAttestationStatement);
                    break;
                }
                throw new IllegalStateException();
            }
            case NONE: {
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
    }

    private AttestationType validateAttestationStatement(RegistrationObject registrationObject) {
        for (AttestationStatementValidator validator : this.attestationStatementValidators) {
            if (!validator.supports(registrationObject)) continue;
            return validator.validate(registrationObject);
        }
        throw new BadAttestationStatementException("Supplied AttestationStatement format is not configured.");
    }
}

