/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.attestation.trustworthiness.certpath;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import com.webauthn4j.verifier.attestation.trustworthiness.certpath.CertPathTrustworthinessVerifier;
import com.webauthn4j.verifier.exception.CertificateException;
import com.webauthn4j.verifier.exception.TrustAnchorNotFoundException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class CertPathTrustworthinessVerifierBase
implements CertPathTrustworthinessVerifier {
    private boolean fullChainProhibited = false;
    private boolean revocationCheckEnabled = false;
    private boolean policyQualifiersRejected = false;

    @Override
    public void verify(@NotNull AAGUID aaguid, @NotNull CertificateBaseAttestationStatement attestationStatement, @NotNull Instant timestamp) {
        PKIXCertPathValidatorResult result;
        AssertUtil.notNull(aaguid, "aaguid must not be null");
        AssertUtil.notNull(attestationStatement, "attestationStatement must not be null");
        AssertUtil.notNull(timestamp, "timestamp must not be null");
        CertPath certPath = attestationStatement.getX5c().createCertPath();
        Set<TrustAnchor> trustAnchors = this.resolveTrustAnchors(aaguid);
        if (trustAnchors.isEmpty()) {
            throw new TrustAnchorNotFoundException("TrustAnchors are not found for AAGUID: " + aaguid.toString());
        }
        CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
        PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters(trustAnchors);
        certPathParameters.setPolicyQualifiersRejected(this.policyQualifiersRejected);
        certPathParameters.setRevocationEnabled(this.revocationCheckEnabled);
        certPathParameters.setDate(Date.from(timestamp));
        try {
            result = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, certPathParameters);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException("invalid algorithm parameter", e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException("invalid cert path", e);
        }
        if (this.fullChainProhibited && certPath.getCertificates().contains(result.getTrustAnchor().getTrustedCert())) {
            throw new CertificateException("`certpath` must not contain full chain.");
        }
    }

    @NotNull
    protected abstract Set<TrustAnchor> resolveTrustAnchors(@NotNull AAGUID var1);

    public boolean isFullChainProhibited() {
        return this.fullChainProhibited;
    }

    public void setFullChainProhibited(boolean fullChainProhibited) {
        this.fullChainProhibited = fullChainProhibited;
    }

    public boolean isRevocationCheckEnabled() {
        return this.revocationCheckEnabled;
    }

    public void setRevocationCheckEnabled(boolean revocationCheckEnabled) {
        this.revocationCheckEnabled = revocationCheckEnabled;
    }

    public boolean isPolicyQualifiersRejected() {
        return this.policyQualifiersRejected;
    }

    public void setPolicyQualifiersRejected(boolean policyQualifiersRejected) {
        this.policyQualifiersRejected = policyQualifiersRejected;
    }
}

