/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.converter.jackson.JacksonUtil;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.dataformat.cbor.CBORMapper;

public class CoreRegistrationObject {
    private static final CBORMapper cborMapper = new CBORMapper();
    private final AttestationObject attestationObject;
    private final byte[] attestationObjectBytes;
    private final byte[] clientDataHash;
    private final CoreServerProperty serverProperty;
    private final Instant timestamp;

    public CoreRegistrationObject(@NotNull AttestationObject attestationObject, @NotNull byte[] attestationObjectBytes, @NotNull byte[] clientDataHash, @NotNull CoreServerProperty serverProperty, @NotNull Instant timestamp) {
        AssertUtil.notNull(attestationObject, "attestationObject must not be null");
        AssertUtil.notNull(attestationObjectBytes, "attestationObjectBytes must not be null");
        AssertUtil.notNull(clientDataHash, "clientDataHash must not be null");
        AssertUtil.notNull(serverProperty, "serverProperty must not be null");
        AssertUtil.notNull(timestamp, "timestamp must not be null");
        this.attestationObject = attestationObject;
        this.attestationObjectBytes = attestationObjectBytes;
        this.clientDataHash = clientDataHash;
        this.serverProperty = serverProperty;
        this.timestamp = timestamp;
    }

    public CoreRegistrationObject(@NotNull AttestationObject attestationObject, @NotNull byte[] attestationObjectBytes, @NotNull byte[] clientDataHash, @NotNull CoreServerProperty serverProperty) {
        this(attestationObject, attestationObjectBytes, clientDataHash, serverProperty, Instant.now());
    }

    @NotNull
    private static byte[] extractAuthenticatorData(@NotNull byte[] attestationObject) {
        return JacksonUtil.binaryValue(JacksonUtil.readTree((ObjectMapper)cborMapper, attestationObject).get("authData"));
    }

    @NotNull
    public AttestationObject getAttestationObject() {
        return this.attestationObject;
    }

    @NotNull
    public byte[] getAttestationObjectBytes() {
        return ArrayUtil.clone(this.attestationObjectBytes);
    }

    @NotNull
    public byte[] getAuthenticatorDataBytes() {
        return CoreRegistrationObject.extractAuthenticatorData(this.attestationObjectBytes);
    }

    @NotNull
    public byte[] getClientDataHash() {
        return this.clientDataHash;
    }

    @NotNull
    public CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    @NotNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreRegistrationObject that = (CoreRegistrationObject)o;
        return Objects.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.attestationObjectBytes, that.attestationObjectBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        int result = Objects.hash(this.attestationObject, this.serverProperty, this.timestamp);
        result = 31 * result + Arrays.hashCode(this.attestationObjectBytes);
        result = 31 * result + Arrays.hashCode(this.clientDataHash);
        return result;
    }
}

