/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.webauthn4j.data.extension.SingleValueExtensionOutputBase;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import org.jetbrains.annotations.NotNull;

public class HMACSecretAuthenticationExtensionAuthenticatorOutput
extends SingleValueExtensionOutputBase<byte[]>
implements AuthenticationExtensionAuthenticatorOutput {
    public static final String ID = "hmac-secret";
    public static final String KEY_HMAC_SECRET = "hmac-secret";

    public HMACSecretAuthenticationExtensionAuthenticatorOutput(@NotNull byte[] value) {
        super(value);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "hmac-secret";
    }

    @Override
    public void validate() {
        boolean additionalCtap21AllowedLength;
        if (this.getValue() == null) {
            throw new ConstraintViolationException("value must not be null");
        }
        boolean ctap20AllowedLength = ((byte[])this.getValue()).length == 32 || ((byte[])this.getValue()).length == 64;
        boolean bl = additionalCtap21AllowedLength = ((byte[])this.getValue()).length == 48 || ((byte[])this.getValue()).length == 80;
        if (!ctap20AllowedLength && !additionalCtap21AllowedLength) {
            throw new ConstraintViolationException("hmac-secret output must be 32, 48, 64 or 80 bytes length");
        }
    }
}

