/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.webauthn4j.data.PinProtocolVersion;
import com.webauthn4j.data.extension.SingleValueExtensionInputBase;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorInput;
import com.webauthn4j.data.extension.authenticator.HMACGetSecretAuthenticatorInput;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import org.jetbrains.annotations.NotNull;

public class HMACSecretAuthenticationExtensionAuthenticatorInput
extends SingleValueExtensionInputBase<HMACGetSecretAuthenticatorInput>
implements AuthenticationExtensionAuthenticatorInput {
    public static final String ID = "hmac-secret";
    public static final String KEY_HMAC_SECRET = "hmac-secret";

    public HMACSecretAuthenticationExtensionAuthenticatorInput(@NotNull HMACGetSecretAuthenticatorInput value) {
        super(value);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "hmac-secret";
    }

    @Override
    public void validate() {
        if (this.getValue() == null) {
            throw new ConstraintViolationException("value must not be null");
        }
        if (((HMACGetSecretAuthenticatorInput)this.getValue()).getKeyAgreement() == null) {
            throw new ConstraintViolationException("keyAgreement must not be null");
        }
        if (((HMACGetSecretAuthenticatorInput)this.getValue()).getSaltAuth() == null) {
            throw new ConstraintViolationException("saltAuth must not be null");
        }
        if (((HMACGetSecretAuthenticatorInput)this.getValue()).getSaltEnc() == null) {
            throw new ConstraintViolationException("saltEnc must not be null");
        }
        ((HMACGetSecretAuthenticatorInput)this.getValue()).getKeyAgreement().validate();
        PinProtocolVersion protocol = ((HMACGetSecretAuthenticatorInput)this.getValue()).getPinUvAuthProtocol();
        byte[] saltAuth = ((HMACGetSecretAuthenticatorInput)this.getValue()).getSaltAuth();
        byte[] saltEnc = ((HMACGetSecretAuthenticatorInput)this.getValue()).getSaltEnc();
        if (PinProtocolVersion.VERSION_1.equals(protocol) || protocol == null) {
            if (saltAuth.length != 16) {
                throw new ConstraintViolationException("saltAuth must be 16 bytes length for Protocol 1");
            }
            if (saltEnc.length != 32 && saltEnc.length != 64) {
                throw new ConstraintViolationException("saltEnc must be 32 or 64 bytes length for Protocol 1");
            }
        } else if (PinProtocolVersion.VERSION_2.equals(protocol)) {
            if (saltAuth.length != 32) {
                throw new ConstraintViolationException("saltAuth must be 32 bytes length for Protocol 2");
            }
            if (saltEnc.length != 48 && saltEnc.length != 80) {
                throw new ConstraintViolationException("saltEnc must be 48 or 80 bytes length for Protocol 2");
            }
        } else {
            throw new IllegalStateException("unknown protocol version: " + String.valueOf(protocol));
        }
    }
}

