/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.webauthn4j.converter.jackson.deserializer.cbor.CredentialProtectionPolicyDeserializer;
import com.webauthn4j.converter.jackson.serializer.cbor.CredentialProtectionPolicySerializer;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.extension.SingleValueExtensionBase;
import com.webauthn4j.data.extension.UvmEntries;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.CredentialProtectionExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.HMACSecretAuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.HMACSecretRegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.UserVerificationMethodExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonSerialize;

public class AuthenticationExtensionsAuthenticatorOutputs<T extends ExtensionAuthenticatorOutput> {
    private static final String KEY_UVM = "uvm";
    private static final String KEY_CRED_PROTECT = "credProtect";
    private static final String KEY_HMAC_SECRET = "hmac-secret";
    @JsonIgnore
    private final Map<String, Object> unknowns = new HashMap<String, Object>();
    @JsonProperty
    private UvmEntries uvm;
    @JsonSerialize(using=CredentialProtectionPolicySerializer.class)
    @JsonDeserialize(using=CredentialProtectionPolicyDeserializer.class)
    @JsonProperty
    private CredentialProtectionPolicy credProtect;
    @JsonIgnore
    private Boolean hmacCreateSecret;
    @JsonIgnore
    private byte[] hmacGetSecret;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonSetter(value="hmac-secret")
    private void setHMACSecret(@Nullable Object hmacSecret) {
        if (hmacSecret instanceof Boolean) {
            this.hmacCreateSecret = (Boolean)hmacSecret;
            this.hmacGetSecret = null;
        } else {
            this.hmacCreateSecret = null;
            this.hmacGetSecret = (byte[])hmacSecret;
        }
    }

    @JsonAnySetter
    private void setUnknowns(@NotNull String name, @Nullable Object value) {
        this.unknowns.put(name, value);
    }

    @JsonAnyGetter
    @NotNull
    private Map<String, Object> getUnknowns() {
        return this.unknowns;
    }

    @JsonIgnore
    @NotNull
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.uvm != null) {
            keys.add(KEY_UVM);
        }
        if (this.credProtect != null) {
            keys.add(KEY_CRED_PROTECT);
        }
        if (this.hmacCreateSecret != null) {
            keys.add(KEY_HMAC_SECRET);
        }
        if (this.hmacGetSecret != null) {
            keys.add(KEY_HMAC_SECRET);
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    @NotNull
    public Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    @Nullable
    public Object getValue(@NotNull String key) {
        switch (key) {
            case "uvm": {
                return this.uvm;
            }
            case "credProtect": {
                return this.credProtect;
            }
            case "hmac-secret": {
                return this.hmacCreateSecret != null ? this.hmacCreateSecret : (Object)this.hmacGetSecret;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    @Nullable
    public UvmEntries getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    @Nullable
    public CredentialProtectionPolicy getCredProtect() {
        return this.credProtect;
    }

    @JsonGetter(value="hmac-secret")
    @Nullable
    public Object getHMACSecret() {
        return this.hmacCreateSecret != null ? this.hmacCreateSecret : (Object)this.hmacGetSecret;
    }

    @JsonIgnore
    @Nullable
    public Boolean getHMACCreateSecret() {
        return this.hmacCreateSecret;
    }

    @JsonIgnore
    @Nullable
    public byte[] getHMACGetSecret() {
        return this.hmacGetSecret;
    }

    @Nullable
    public <E extends T> E getExtension(@NotNull Class<E> tClass) {
        return (E)((ExtensionAuthenticatorOutput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    @NotNull
    public Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class, SingleValueExtensionBase> map = new HashMap<Class, SingleValueExtensionBase>();
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionAuthenticatorOutput.class, new UserVerificationMethodExtensionAuthenticatorOutput(this.uvm));
            }
            if (this.credProtect != null) {
                map.put(CredentialProtectionExtensionAuthenticatorOutput.class, new CredentialProtectionExtensionAuthenticatorOutput(this.credProtect));
            }
            if (this.hmacCreateSecret != null) {
                map.put(HMACSecretRegistrationExtensionAuthenticatorOutput.class, new HMACSecretRegistrationExtensionAuthenticatorOutput(this.hmacCreateSecret));
            }
            if (this.hmacGetSecret != null) {
                map.put(HMACSecretAuthenticationExtensionAuthenticatorOutput.class, new HMACSecretAuthenticationExtensionAuthenticatorOutput(this.hmacGetSecret));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsAuthenticatorOutputs that = (AuthenticationExtensionsAuthenticatorOutputs)o;
        return Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.uvm, that.uvm) && this.credProtect == that.credProtect && Objects.equals(this.hmacCreateSecret, that.hmacCreateSecret) && Arrays.equals(this.hmacGetSecret, that.hmacGetSecret) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.unknowns, this.uvm, this.credProtect, this.hmacCreateSecret, this.extensions});
        result = 31 * result + Arrays.hashCode(this.hmacGetSecret);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticationExtensionsAuthenticatorInputs(");
        String entries = this.getExtensions().values().stream().map(t -> String.format("%s=%s", t.getIdentifier(), t)).collect(Collectors.joining(", "));
        builder.append(entries);
        String unknownsStr = this.getUnknowns().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (!unknownsStr.isEmpty()) {
            builder.append(", ");
            builder.append(unknownsStr);
        }
        builder.append(")");
        return builder.toString();
    }

    public static class BuilderForAuthentication {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private UvmEntries uvm;
        private byte[] hmacGetSecret;

        @NotNull
        public AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> build() {
            AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> instance = new AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput>();
            instance.uvm = this.uvm;
            instance.unknowns.putAll(this.unknowns);
            instance.hmacGetSecret = this.hmacGetSecret;
            return instance;
        }

        @NotNull
        public BuilderForAuthentication setUvm(@Nullable UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        @NotNull
        public BuilderForAuthentication setHMACGetSecret(@Nullable byte[] hmacGetSecret) {
            this.hmacGetSecret = hmacGetSecret;
            return this;
        }

        @NotNull
        public BuilderForAuthentication set(@NotNull String key, @Nullable Object value) {
            AssertUtil.notNull(key, "key must not be null.");
            AssertUtil.notNull(value, "value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Object> unknowns = new HashMap<String, Object>();
        private UvmEntries uvm;
        private CredentialProtectionPolicy credProtect;
        private Boolean hmacCreateSecret;

        @NotNull
        public AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> build() {
            AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> instance = new AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput>();
            instance.uvm = this.uvm;
            instance.credProtect = this.credProtect;
            instance.unknowns.putAll(this.unknowns);
            instance.hmacCreateSecret = this.hmacCreateSecret;
            return instance;
        }

        @NotNull
        public BuilderForRegistration setUvm(@Nullable UvmEntries uvm) {
            this.uvm = uvm;
            return this;
        }

        @NotNull
        public BuilderForRegistration setCredProtect(@Nullable CredentialProtectionPolicy credProtect) {
            this.credProtect = credProtect;
            return this;
        }

        @NotNull
        public BuilderForRegistration setHMACCreateSecret(@Nullable Boolean hmacCreateSecret) {
            this.hmacCreateSecret = hmacCreateSecret;
            return this;
        }

        @NotNull
        public BuilderForRegistration set(@NotNull String key, @Nullable Object value) {
            AssertUtil.notNull(key, "key must not be null.");
            AssertUtil.notNull(value, "value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

