/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.data.MessageDigestAlgorithm;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.exc.InvalidFormatException;

public class SignatureAlgorithm {
    private static final String JCA_SHA_256_WITH_ECDSA = "SHA256withECDSA";
    private static final String JCA_SHA_384_WITH_ECDSA = "SHA384withECDSA";
    private static final String JCA_SHA_512_WITH_ECDSA = "SHA512withECDSA";
    private static final String JCA_SHA_1_WITH_RSA = "SHA1withRSA";
    private static final String JCA_SHA_256_WITH_RSA = "SHA256withRSA";
    private static final String JCA_SHA_384_WITH_RSA = "SHA384withRSA";
    private static final String JCA_SHA_512_WITH_RSA = "SHA512withRSA";
    private static final String JCA_ED_25519 = "ed25519";
    private static final String JCA_RSA_SSA_PSS = "RSASSA-PSS";
    private static final String SHA_256_WITH_RSA_PSS = "SHA256withRSA/PSS";
    private static final String SHA_384_WITH_RSA_PSS = "SHA384withRSA/PSS";
    private static final String SHA_512_WITH_RSA_PSS = "SHA512withRSA/PSS";
    public static final SignatureAlgorithm ES256 = new SignatureAlgorithm("SHA256withECDSA", MessageDigestAlgorithm.SHA256);
    public static final SignatureAlgorithm ES384 = new SignatureAlgorithm("SHA384withECDSA", MessageDigestAlgorithm.SHA384);
    public static final SignatureAlgorithm ES512 = new SignatureAlgorithm("SHA512withECDSA", MessageDigestAlgorithm.SHA512);
    public static final SignatureAlgorithm RS1 = new SignatureAlgorithm("SHA1withRSA", MessageDigestAlgorithm.SHA1);
    public static final SignatureAlgorithm RS256 = new SignatureAlgorithm("SHA256withRSA", MessageDigestAlgorithm.SHA256);
    public static final SignatureAlgorithm RS384 = new SignatureAlgorithm("SHA384withRSA", MessageDigestAlgorithm.SHA384);
    public static final SignatureAlgorithm RS512 = new SignatureAlgorithm("SHA512withRSA", MessageDigestAlgorithm.SHA512);
    public static final SignatureAlgorithm Ed25519 = new SignatureAlgorithm("ed25519", MessageDigestAlgorithm.SHA512);
    public static final SignatureAlgorithm PS256 = new SignatureAlgorithm("RSASSA-PSS", MessageDigestAlgorithm.SHA256);
    public static final SignatureAlgorithm PS384 = new SignatureAlgorithm("RSASSA-PSS", MessageDigestAlgorithm.SHA384);
    public static final SignatureAlgorithm PS512 = new SignatureAlgorithm("RSASSA-PSS", MessageDigestAlgorithm.SHA512);
    private final String jcaName;
    private final MessageDigestAlgorithm messageDigestAlgorithm;

    private SignatureAlgorithm(@NotNull String jcaName, @NotNull MessageDigestAlgorithm messageDigestAlgorithm) {
        this.jcaName = jcaName;
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    @Deprecated
    public static SignatureAlgorithm create(@NotNull String value) {
        switch (value) {
            case "SHA256withECDSA": {
                return ES256;
            }
            case "SHA384withECDSA": {
                return ES384;
            }
            case "SHA512withECDSA": {
                return ES512;
            }
            case "SHA1withRSA": {
                return RS1;
            }
            case "SHA256withRSA": {
                return RS256;
            }
            case "SHA384withRSA": {
                return RS384;
            }
            case "SHA512withRSA": {
                return RS512;
            }
            case "ed25519": {
                return Ed25519;
            }
            case "RSASSA-PSS": {
                throw new IllegalArgumentException(String.format("value %s is not supported by SignatureAlgorithm.create(value). Use SignatureAlgorithm.create(jcaName, messageDigestJcaName) instead.", value));
            }
        }
        throw new IllegalArgumentException(String.format("value %s is not supported.", value));
    }

    public static SignatureAlgorithm create(@NotNull String jcaName, @NotNull String messageDigestJcaName) {
        return new SignatureAlgorithm(jcaName, MessageDigestAlgorithm.create(messageDigestJcaName));
    }

    @JsonCreator
    @NotNull
    static SignatureAlgorithm deserialize(String value) throws InvalidFormatException {
        try {
            switch (value) {
                case "SHA256withECDSA": {
                    return ES256;
                }
                case "SHA384withECDSA": {
                    return ES384;
                }
                case "SHA512withECDSA": {
                    return ES512;
                }
                case "SHA1withRSA": {
                    return RS1;
                }
                case "SHA256withRSA": {
                    return RS256;
                }
                case "SHA384withRSA": {
                    return RS384;
                }
                case "SHA512withRSA": {
                    return RS512;
                }
                case "ed25519": {
                    return Ed25519;
                }
                case "SHA256withRSA/PSS": {
                    return PS256;
                }
                case "SHA384withRSA/PSS": {
                    return PS384;
                }
                case "SHA512withRSA/PSS": {
                    return PS512;
                }
                case "RSASSA-PSS": {
                    throw new IllegalArgumentException(String.format("value %s is not valid text representation of SignatureAlgorithm.", value));
                }
            }
            throw new IllegalArgumentException(String.format("value %s is not supported.", value));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, SignatureAlgorithm.class);
        }
    }

    @JsonValue
    @NotNull
    public String serialize() {
        if (this.jcaName.equals(JCA_RSA_SSA_PSS)) {
            if (this.messageDigestAlgorithm.equals(MessageDigestAlgorithm.SHA256)) {
                return SHA_256_WITH_RSA_PSS;
            }
            if (this.messageDigestAlgorithm.equals(MessageDigestAlgorithm.SHA384)) {
                return SHA_384_WITH_RSA_PSS;
            }
            if (this.messageDigestAlgorithm.equals(MessageDigestAlgorithm.SHA512)) {
                return SHA_512_WITH_RSA_PSS;
            }
            throw new IllegalStateException("Unexpected messageDigestAlgorithm is specified");
        }
        return this.jcaName;
    }

    @NotNull
    public String getJcaName() {
        return this.jcaName;
    }

    @NotNull
    public MessageDigestAlgorithm getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureAlgorithm that = (SignatureAlgorithm)o;
        return Objects.equals(this.jcaName, that.jcaName) && Objects.equals(this.messageDigestAlgorithm, that.messageDigestAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(this.jcaName, this.messageDigestAlgorithm);
    }

    public String toString() {
        String value;
        switch (value = this.serialize()) {
            case "SHA256withECDSA": {
                return "ES256";
            }
            case "SHA384withECDSA": {
                return "ES384";
            }
            case "SHA512withECDSA": {
                return "ES512";
            }
            case "SHA1withRSA": {
                return "RS1";
            }
            case "SHA256withRSA": {
                return "RS256";
            }
            case "SHA384withRSA": {
                return "RS384";
            }
            case "SHA512withRSA": {
                return "RS512";
            }
            case "ed25519": {
                return "Ed25519";
            }
            case "SHA256withRSA/PSS": {
                return "PS256";
            }
            case "SHA384withRSA/PSS": {
                return "PS384";
            }
            case "SHA512withRSA/PSS": {
                return "PS512";
            }
        }
        return "Unknown value: " + value;
    }
}

