/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MessageDigestUtil;
import java.security.MessageDigest;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.exc.InvalidFormatException;

public class MessageDigestAlgorithm {
    public static final MessageDigestAlgorithm SHA1 = new MessageDigestAlgorithm("SHA-1");
    public static final MessageDigestAlgorithm SHA256 = new MessageDigestAlgorithm("SHA-256");
    public static final MessageDigestAlgorithm SHA384 = new MessageDigestAlgorithm("SHA-384");
    public static final MessageDigestAlgorithm SHA512 = new MessageDigestAlgorithm("SHA-512");
    private final String jcaName;

    private MessageDigestAlgorithm(@NotNull String jcaName) {
        this.jcaName = jcaName;
    }

    @NotNull
    public static MessageDigestAlgorithm create(@NotNull String jcaName) {
        AssertUtil.notNull(jcaName, "jcaName must not be null");
        return new MessageDigestAlgorithm(jcaName);
    }

    @JsonCreator
    @NotNull
    private static MessageDigestAlgorithm deserialize(String value) throws InvalidFormatException {
        try {
            return MessageDigestAlgorithm.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, MessageDigestAlgorithm.class);
        }
    }

    @JsonValue
    @NotNull
    public String getJcaName() {
        return this.jcaName;
    }

    @NotNull
    public MessageDigest createMessageDigestObject() {
        return MessageDigestUtil.createMessageDigest(this.jcaName);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageDigestAlgorithm that = (MessageDigestAlgorithm)o;
        return Objects.equals(this.jcaName, that.jcaName);
    }

    public int hashCode() {
        return Objects.hash(this.jcaName);
    }

    public String toString() {
        return this.jcaName;
    }
}

