/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.json;

import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;

public class JWSHeaderSerializer
extends StdSerializer<JWSHeader> {
    public JWSHeaderSerializer() {
        super(JWSHeader.class);
    }

    public void serialize(@NotNull JWSHeader value, @NotNull JsonGenerator gen, @NotNull SerializationContext provider) {
        try {
            gen.writeStartObject();
            gen.writePOJOProperty("alg", (Object)value.getAlg());
            gen.writeName("x5c");
            gen.writeStartArray();
            if (value.getX5c() != null) {
                for (Certificate certificate : value.getX5c().getCertificates()) {
                    gen.writeString(Base64Util.encodeToString(certificate.getEncoded()));
                }
            }
            gen.writeEndArray();
        }
        catch (CertificateEncodingException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

