/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.cbor;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.dataformat.cbor.CBORGenerator;

public abstract class AbstractCtapCanonicalCborSerializer<T>
extends StdSerializer<T> {
    private final transient List<FieldSerializationRule<T, ?>> rules;

    protected AbstractCtapCanonicalCborSerializer(@NotNull Class<T> t, @NotNull List<FieldSerializationRule<T, ?>> rules) {
        super(t);
        this.rules = rules;
    }

    public void serialize(@NotNull T value, @NotNull JsonGenerator gen, @NotNull SerializationContext provider) {
        List nonNullValues = this.rules.stream().map(rule -> {
            Object fieldValue = rule.getGetter().apply(value);
            return new KeyValue(rule.getName(), fieldValue);
        }).filter(item -> item.value != null).collect(Collectors.toList());
        ((CBORGenerator)gen).writeStartObject(null, nonNullValues.size());
        for (KeyValue nonNullValue : nonNullValues) {
            if (nonNullValue.name instanceof String) {
                gen.writeName((String)nonNullValue.name);
            } else {
                gen.writePropertyId((long)((Integer)nonNullValue.name).intValue());
            }
            gen.writePOJO(nonNullValue.value);
        }
        gen.writeEndObject();
    }

    private static class KeyValue {
        @NotNull
        private final Object name;
        @Nullable
        private final Object value;

        public KeyValue(@NotNull Object name, @Nullable Object value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class FieldSerializationRule<T, R> {
        @NotNull
        private final Object name;
        @NotNull
        private final Function<T, R> getter;

        public FieldSerializationRule(int name, @NotNull Function<T, @Nullable R> getter) {
            this.name = name;
            this.getter = getter;
        }

        public FieldSerializationRule(@NotNull String name, @NotNull Function<T, @Nullable R> getter) {
            this.name = name;
            this.getter = getter;
        }

        @NotNull
        public Object getName() {
            return this.name;
        }

        @NotNull
        public @NotNull Function<T, @NotNull R> getGetter() {
            return this.getter;
        }
    }
}

