/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.exc.InvalidFormatException;

public class ChallengeDeserializer
extends StdDeserializer<Challenge> {
    public ChallengeDeserializer() {
        super(Challenge.class);
    }

    @NotNull
    public Challenge deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        String str = p.getValueAsString();
        try {
            return new DefaultChallenge(str);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)str, DefaultChallenge.class);
        }
    }
}

