/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.webauthn4j.data.AttachmentHint;
import com.webauthn4j.data.AuthenticatorAttestationType;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.exc.InvalidFormatException;

public class AuthenticatorAttestationTypeFromIntDeserializer
extends StdDeserializer<AuthenticatorAttestationType> {
    public AuthenticatorAttestationTypeFromIntDeserializer() {
        super(AuthenticatorAttestationType.class);
    }

    public AuthenticatorAttestationType deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        int value = p.getValueAsInt();
        try {
            return AuthenticatorAttestationType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AttachmentHint.class);
        }
    }
}

