/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;

public class AuthenticatorDataDeserializer
extends StdDeserializer<AuthenticatorData<? extends ExtensionAuthenticatorOutput>> {
    private final ObjectConverter objectConverter;

    public AuthenticatorDataDeserializer(ObjectConverter objectConverter) {
        super(AuthenticatorData.class);
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.objectConverter = objectConverter;
    }

    @NotNull
    public AuthenticatorData<? extends ExtensionAuthenticatorOutput> deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        byte[] value = p.getBinaryValue();
        return new AuthenticatorDataConverter(this.objectConverter).convert(value);
    }
}

