/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.webauthn4j.converter.jackson.deserializer.cbor.AAGUIDDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.AttestedCredentialDataDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.AuthenticationExtensionsAuthenticatorOutputsEnvelope;
import com.webauthn4j.converter.jackson.deserializer.cbor.AuthenticationExtensionsAuthenticatorOutputsEnvelopeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.AuthenticatorDataDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.COSEKeyEnvelope;
import com.webauthn4j.converter.jackson.deserializer.cbor.COSEKeyEnvelopeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.CertPathDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.CredentialProtectionPolicyDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.JWSDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.TPMSAttestDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.TPMTPublicDeserializer;
import com.webauthn4j.converter.jackson.deserializer.cbor.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AAGUIDSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AndroidKeyAttestationStatementSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AndroidSafetyNetAttestationStatementSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AppleAnonymousAttestationStatementSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AttestationObjectSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AttestedCredentialDataSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AuthenticationExtensionsAuthenticatorInputsSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AuthenticationExtensionsAuthenticatorOutputsSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.AuthenticatorDataSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.CertPathSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.CredentialProtectionPolicySerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.EC2COSEKeySerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.EdDSACOSEKeySerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.FIDOU2FAttestationStatementSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.HMACGetSecretAuthenticatorInputSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.JWSSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.NoneAttestationStatementSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.PackedAttestationStatementSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.PublicKeyCredentialDescriptorSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.RSACOSEKeySerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.TPMAttestationStatementSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.TPMSAttestSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.TPMTPublicSerializer;
import com.webauthn4j.converter.jackson.serializer.cbor.X509CertificateSerializer;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.statement.AndroidKeyAttestationStatement;
import com.webauthn4j.data.attestation.statement.AndroidSafetyNetAttestationStatement;
import com.webauthn4j.data.attestation.statement.AppleAnonymousAttestationStatement;
import com.webauthn4j.data.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.data.attestation.statement.NoneAttestationStatement;
import com.webauthn4j.data.attestation.statement.PackedAttestationStatement;
import com.webauthn4j.data.attestation.statement.TPMAttestationStatement;
import com.webauthn4j.data.attestation.statement.TPMSAttest;
import com.webauthn4j.data.attestation.statement.TPMTPublic;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.util.AssertUtil;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.module.SimpleModule;

public class WebAuthnCBORModule
extends SimpleModule {
    public WebAuthnCBORModule(@NotNull ObjectConverter objectConverter) {
        super("WebAuthnCBORModule");
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.addDeserializer(AAGUID.class, (ValueDeserializer)new AAGUIDDeserializer());
        this.addDeserializer(AttestedCredentialData.class, (ValueDeserializer)new AttestedCredentialDataDeserializer(objectConverter));
        this.addDeserializer(AuthenticationExtensionsAuthenticatorOutputsEnvelope.class, (ValueDeserializer)new AuthenticationExtensionsAuthenticatorOutputsEnvelopeDeserializer());
        this.addDeserializer(AuthenticatorData.class, (ValueDeserializer)new AuthenticatorDataDeserializer(objectConverter));
        this.addDeserializer(CertPath.class, (ValueDeserializer)new CertPathDeserializer());
        this.addDeserializer(COSEKeyEnvelope.class, (ValueDeserializer)new COSEKeyEnvelopeDeserializer());
        this.addDeserializer(CredentialProtectionPolicy.class, (ValueDeserializer)new CredentialProtectionPolicyDeserializer());
        this.addDeserializer(JWS.class, (ValueDeserializer)new JWSDeserializer(objectConverter));
        this.addDeserializer(TPMSAttest.class, (ValueDeserializer)new TPMSAttestDeserializer());
        this.addDeserializer(TPMTPublic.class, (ValueDeserializer)new TPMTPublicDeserializer());
        this.addDeserializer(X509Certificate.class, (ValueDeserializer)new X509CertificateDeserializer());
        this.addSerializer((ValueSerializer)new AttestationObjectSerializer());
        this.addSerializer((ValueSerializer)new AAGUIDSerializer());
        this.addSerializer((ValueSerializer)new AndroidKeyAttestationStatementSerializer());
        this.addSerializer((ValueSerializer)new AndroidSafetyNetAttestationStatementSerializer());
        this.addSerializer((ValueSerializer)new AppleAnonymousAttestationStatementSerializer());
        this.addSerializer((ValueSerializer)new NoneAttestationStatementSerializer());
        this.addSerializer((ValueSerializer)new AttestedCredentialDataSerializer(objectConverter));
        this.addSerializer((ValueSerializer)new AuthenticationExtensionsAuthenticatorInputsSerializer());
        this.addSerializer((ValueSerializer)new AuthenticationExtensionsAuthenticatorOutputsSerializer());
        this.addSerializer((ValueSerializer)new AuthenticatorDataSerializer(objectConverter));
        this.addSerializer((ValueSerializer)new CertPathSerializer());
        this.addSerializer((ValueSerializer)new CredentialProtectionPolicySerializer());
        this.addSerializer((ValueSerializer)new EC2COSEKeySerializer());
        this.addSerializer((ValueSerializer)new EdDSACOSEKeySerializer());
        this.addSerializer((ValueSerializer)new FIDOU2FAttestationStatementSerializer());
        this.addSerializer((ValueSerializer)new HMACGetSecretAuthenticatorInputSerializer());
        this.addSerializer((ValueSerializer)new JWSSerializer());
        this.addSerializer((ValueSerializer)new PackedAttestationStatementSerializer());
        this.addSerializer((ValueSerializer)new PublicKeyCredentialDescriptorSerializer());
        this.addSerializer((ValueSerializer)new RSACOSEKeySerializer());
        this.addSerializer((ValueSerializer)new TPMAttestationStatementSerializer());
        this.addSerializer((ValueSerializer)new TPMSAttestSerializer());
        this.addSerializer((ValueSerializer)new TPMTPublicSerializer());
        this.addSerializer((ValueSerializer)new X509CertificateSerializer());
        this.registerSubtypes(new NamedType[]{new NamedType(FIDOU2FAttestationStatement.class, "fido-u2f")});
        this.registerSubtypes(new NamedType[]{new NamedType(PackedAttestationStatement.class, "packed")});
        this.registerSubtypes(new NamedType[]{new NamedType(AndroidKeyAttestationStatement.class, "android-key")});
        this.registerSubtypes(new NamedType[]{new NamedType(AndroidSafetyNetAttestationStatement.class, "android-safetynet")});
        this.registerSubtypes(new NamedType[]{new NamedType(TPMAttestationStatement.class, "tpm")});
        this.registerSubtypes(new NamedType[]{new NamedType(AppleAnonymousAttestationStatement.class, "apple")});
        this.registerSubtypes(new NamedType[]{new NamedType(NoneAttestationStatement.class, "none")});
    }
}

