/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.type.TypeReference;

public class AuthenticationExtensionsClientOutputsConverter {
    private final ObjectConverter objectConverter;

    public AuthenticationExtensionsClientOutputsConverter(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.objectConverter = objectConverter;
    }

    @Nullable
    public <T extends ExtensionClientOutput> AuthenticationExtensionsClientOutputs<T> convert(@NotNull String value) {
        try {
            AssertUtil.notNull(value, "value must not be null");
            return (AuthenticationExtensionsClientOutputs)this.objectConverter.getJsonMapper().readValue(value, new TypeReference<AuthenticationExtensionsClientOutputs<T>>(){});
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public <T extends ExtensionClientOutput> String convertToString(@NotNull AuthenticationExtensionsClientOutputs<T> value) {
        try {
            AssertUtil.notNull(value, "value must not be null");
            return this.objectConverter.getJsonMapper().writeValueAsString(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }
}

