/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientInputs;
import com.webauthn4j.data.extension.client.ExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.type.TypeReference;

public class AuthenticationExtensionsClientInputsConverter {
    private final ObjectConverter objectConverter;

    public AuthenticationExtensionsClientInputsConverter(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.objectConverter = objectConverter;
    }

    @Nullable
    public <T extends ExtensionClientInput> AuthenticationExtensionsClientInputs<T> convert(@NotNull String value) {
        try {
            AssertUtil.notNull(value, "value must not be null");
            return (AuthenticationExtensionsClientInputs)this.objectConverter.getJsonMapper().readValue(value, new TypeReference<AuthenticationExtensionsClientInputs<T>>(){});
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public <T extends ExtensionClientInput> String convertToString(@NotNull AuthenticationExtensionsClientInputs<T> value) {
        try {
            AssertUtil.notNull(value, "value must not be null");
            return this.objectConverter.getJsonMapper().writeValueAsString(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }
}

