/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AuthenticationObject;
import com.webauthn4j.verifier.OriginVerifier;
import com.webauthn4j.verifier.RegistrationObject;
import com.webauthn4j.verifier.exception.BadOriginException;
import org.jetbrains.annotations.NotNull;

public class OriginVerifierImpl
implements OriginVerifier {
    @Override
    public void verify(@NotNull RegistrationObject registrationObject) {
        AssertUtil.notNull(registrationObject, "registrationObject must not be null");
        CollectedClientData collectedClientData = registrationObject.getCollectedClientData();
        ServerProperty serverProperty = registrationObject.getServerProperty();
        this.verify(collectedClientData, serverProperty);
    }

    @Override
    public void verify(@NotNull AuthenticationObject authenticationObject) {
        AssertUtil.notNull(authenticationObject, "authenticationObject must not be null");
        CollectedClientData collectedClientData = authenticationObject.getCollectedClientData();
        ServerProperty serverProperty = authenticationObject.getServerProperty();
        this.verify(collectedClientData, serverProperty);
    }

    protected void verify(@NotNull CollectedClientData collectedClientData, @NotNull ServerProperty serverProperty) {
        AssertUtil.notNull(collectedClientData, "collectedClientData must not be null");
        AssertUtil.notNull(serverProperty, "serverProperty must not be null");
        Origin clientOrigin = collectedClientData.getOrigin();
        if (!serverProperty.getOriginPredicate().test(clientOrigin)) {
            throw new BadOriginException("The collectedClientData origin '" + String.valueOf(clientOrigin) + "' doesn't match any of the preconfigured server origin.");
        }
    }
}

