/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.server;

import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.AnyOriginPredicate;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.server.NoOriginPredicate;
import com.webauthn4j.server.OriginPredicate;
import com.webauthn4j.server.SimpleOriginPredicate;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerProperty
extends CoreServerProperty {
    private final OriginPredicate originPredicate;
    private final OriginPredicate topOriginPredicate;
    private final byte[] tokenBindingId;
    private Set<Origin> origins = Collections.emptySet();

    public static Builder builder() {
        return new Builder();
    }

    private ServerProperty(@NotNull OriginPredicate originPredicate, @NotNull String rpId, @Nullable Challenge challenge, @Nullable OriginPredicate topOriginPredicate) {
        super(rpId, challenge);
        AssertUtil.notNull(originPredicate, "originPredicate must not be null");
        this.originPredicate = originPredicate;
        this.tokenBindingId = null;
        this.topOriginPredicate = topOriginPredicate;
    }

    @Deprecated
    private ServerProperty(@NotNull OriginPredicate originPredicate, @NotNull String rpId, @Nullable Challenge challenge, @Nullable OriginPredicate topOriginPredicate, @Nullable byte[] tokenBindingId) {
        super(rpId, challenge);
        AssertUtil.notNull(originPredicate, "originPredicate must not be null");
        this.originPredicate = originPredicate;
        this.topOriginPredicate = topOriginPredicate;
        this.tokenBindingId = tokenBindingId;
    }

    @Deprecated
    public ServerProperty(@NotNull Origin origin, @NotNull String rpId, @Nullable Challenge challenge) {
        this(new SimpleOriginPredicate(origin), rpId, challenge, null, null);
        this.origins = Collections.singleton(origin);
    }

    @Deprecated
    public ServerProperty(@NotNull Set<Origin> origins, @NotNull String rpId, @Nullable Challenge challenge) {
        this(new SimpleOriginPredicate(origins), rpId, challenge, null, null);
        this.origins = origins;
    }

    @Deprecated
    public ServerProperty(@NotNull Origin origin, @NotNull String rpId, @Nullable Challenge challenge, @Nullable byte[] tokenBindingId) {
        this(new SimpleOriginPredicate(origin), rpId, challenge, null, tokenBindingId);
        this.origins = Collections.singleton(origin);
    }

    @Deprecated
    public ServerProperty(@NotNull Set<Origin> origins, @NotNull String rpId, @Nullable Challenge challenge, @Nullable byte[] tokenBindingId) {
        this(new SimpleOriginPredicate(origins), rpId, challenge, null, tokenBindingId);
        this.origins = origins;
    }

    @Deprecated
    @NotNull
    public Set<Origin> getOrigins() {
        return this.origins;
    }

    @NotNull
    public OriginPredicate getOriginPredicate() {
        return this.originPredicate;
    }

    @Nullable
    public OriginPredicate getTopOriginPredicate() {
        return this.topOriginPredicate;
    }

    @Deprecated(forRemoval=false)
    @Nullable
    public byte[] getTokenBindingId() {
        return this.tokenBindingId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerProperty that = (ServerProperty)o;
        return Objects.equals(this.originPredicate, that.originPredicate) && Objects.equals(this.topOriginPredicate, that.topOriginPredicate) && Objects.deepEquals(this.tokenBindingId, that.tokenBindingId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originPredicate, this.topOriginPredicate, Arrays.hashCode(this.tokenBindingId));
    }

    @Override
    public String toString() {
        return "ServerProperty{originPredicate=" + String.valueOf(this.originPredicate) + ", topOriginPredicate=" + String.valueOf(this.topOriginPredicate) + ", tokenBindingId=" + Arrays.toString(this.tokenBindingId) + ", origins=" + String.valueOf(this.origins) + "}";
    }

    public static class Builder {
        private OriginPredicate originPredicate;
        private String rpId;
        private Challenge challenge;
        private OriginPredicate topOriginPredicate;

        private Builder() {
        }

        public Builder origin(@NotNull Origin value) {
            AssertUtil.notNull(value, "value must not be null");
            this.originPredicate = new SimpleOriginPredicate(value);
            return this;
        }

        public Builder origins(@NotNull Set<Origin> value) {
            AssertUtil.notNull(value, "value must not be null");
            AssertUtil.notEmpty(value, "value must not be empty");
            this.originPredicate = new SimpleOriginPredicate(value);
            return this;
        }

        public Builder originPredicate(@NotNull OriginPredicate value) {
            AssertUtil.notNull(value, "value must not be null");
            this.originPredicate = value;
            return this;
        }

        public Builder rpId(String value) {
            this.rpId = value;
            return this;
        }

        public Builder challenge(Challenge value) {
            this.challenge = value;
            return this;
        }

        public Builder topOrigin(@Nullable Origin value) {
            this.topOriginPredicate = value == null ? new NoOriginPredicate() : new SimpleOriginPredicate(value);
            return this;
        }

        public Builder topOrigins(@Nullable Set<Origin> value) {
            this.topOriginPredicate = value == null || value.isEmpty() ? new NoOriginPredicate() : new SimpleOriginPredicate(value);
            return this;
        }

        public Builder anyTopOrigin() {
            this.topOriginPredicate = new AnyOriginPredicate();
            return this;
        }

        public Builder topOriginPredicate(OriginPredicate value) {
            this.topOriginPredicate = value;
            return this;
        }

        public ServerProperty build() {
            AssertUtil.notNull(this.originPredicate, "originPredicate must not be null. Use origin(), origins() or originPredicate() to set it");
            AssertUtil.notNull(this.rpId, "rpId must not be null");
            return new ServerProperty(this.originPredicate, this.rpId, this.challenge, this.topOriginPredicate);
        }
    }
}

