/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.credential;

import com.webauthn4j.credential.CoreCredentialRecordImpl;
import com.webauthn4j.credential.CredentialRecord;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CredentialRecordImpl
extends CoreCredentialRecordImpl
implements CredentialRecord {
    private final CollectedClientData clientData;
    private final AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions;
    private final Set<AuthenticatorTransport> transports;

    public CredentialRecordImpl(@NotNull AttestationObject attestationObject, @Nullable CollectedClientData clientData, @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, @Nullable Set<AuthenticatorTransport> transports) {
        super(attestationObject);
        this.clientData = clientData;
        this.clientExtensions = clientExtensions;
        this.transports = transports;
    }

    public CredentialRecordImpl(@Nullable AttestationStatement attestationStatement, @Nullable Boolean uvInitialized, @Nullable Boolean backupEligible, @Nullable Boolean backupState, long counter, @NotNull AttestedCredentialData attestedCredentialData, @Nullable AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions, @Nullable CollectedClientData clientData, @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, @Nullable Set<AuthenticatorTransport> transports) {
        super(attestationStatement, uvInitialized, backupEligible, backupState, counter, attestedCredentialData, authenticatorExtensions);
        this.clientData = clientData;
        this.clientExtensions = clientExtensions;
        this.transports = transports;
    }

    @Override
    @Nullable
    public CollectedClientData getClientData() {
        return this.clientData;
    }

    @Override
    @Nullable
    public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    @Override
    @Nullable
    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CredentialRecordImpl that = (CredentialRecordImpl)o;
        return Objects.equals(this.clientData, that.clientData) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.transports, that.transports);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientData, this.clientExtensions, this.transports);
    }
}

