/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.data.attestation.statement.TPMSAttest;
import com.webauthn4j.data.attestation.statement.TPMTPublic;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="tpm")
public class TPMAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "tpm";
    public static final String VERSION_2_0 = "2.0";
    @JsonProperty
    private final String ver;
    @JsonProperty
    private final COSEAlgorithmIdentifier alg;
    @JsonProperty
    private final AttestationCertificatePath x5c;
    @JsonProperty
    private final byte[] sig;
    @JsonProperty
    private final TPMSAttest certInfo;
    @JsonProperty
    private final TPMTPublic pubArea;

    public TPMAttestationStatement(@JsonProperty(value="ver") @NonNull String ver, @JsonProperty(value="alg") @NonNull COSEAlgorithmIdentifier alg, @JsonProperty(value="x5c") @NonNull AttestationCertificatePath x5c, @JsonProperty(value="sig") @NonNull byte[] sig, @JsonProperty(value="certInfo") @NonNull TPMSAttest certInfo, @JsonProperty(value="pubArea") @NonNull TPMTPublic pubArea) {
        AssertUtil.notNull((Object)ver, (String)"ver must not be null");
        AssertUtil.notNull((Object)alg, (String)"alg must not be null");
        AssertUtil.notNull((Object)x5c, (String)"x5c must not be null");
        AssertUtil.notNull((Object)sig, (String)"sig must not be null");
        AssertUtil.notNull((Object)certInfo, (String)"certInfo must not be null");
        AssertUtil.notNull((Object)pubArea, (String)"pubArea must not be null");
        this.ver = ver;
        this.alg = alg;
        this.x5c = x5c;
        this.sig = sig;
        this.certInfo = certInfo;
        this.pubArea = pubArea;
    }

    public TPMAttestationStatement(@NonNull COSEAlgorithmIdentifier alg, @NonNull AttestationCertificatePath x5c, @NonNull byte[] sig, @NonNull TPMSAttest certInfo, @NonNull TPMTPublic pubArea) {
        this(VERSION_2_0, alg, x5c, sig, certInfo, pubArea);
    }

    public @NonNull String getVer() {
        return this.ver;
    }

    public @NonNull COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    @Override
    public @NonNull AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    public @NonNull byte[] getSig() {
        return ArrayUtil.clone((byte[])this.sig);
    }

    public @NonNull TPMSAttest getCertInfo() {
        return this.certInfo;
    }

    public @NonNull TPMTPublic getPubArea() {
        return this.pubArea;
    }

    @Override
    public @NonNull String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.x5c.isEmpty()) {
            throw new ConstraintViolationException("x5c must not be empty");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMAttestationStatement that = (TPMAttestationStatement)o;
        return Objects.equals(this.ver, that.ver) && Objects.equals(this.alg, that.alg) && Objects.equals(this.x5c, that.x5c) && Arrays.equals(this.sig, that.sig) && Objects.equals(this.certInfo, that.certInfo) && Objects.equals(this.pubArea, that.pubArea);
    }

    public int hashCode() {
        int result = Objects.hash(this.ver, this.alg, this.x5c, this.certInfo, this.pubArea);
        result = 31 * result + Arrays.hashCode(this.sig);
        return result;
    }
}

