/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;

public class ObjectConverter
implements Serializable {
    private JsonConverter jsonConverter;
    private CborConverter cborConverter;

    public ObjectConverter(ObjectMapper jsonMapper, ObjectMapper cborMapper) {
        AssertUtil.notNull((Object)jsonMapper, (String)"jsonMapper must not be null");
        AssertUtil.notNull((Object)cborMapper, (String)"cborMapper must not be null");
        AssertUtil.isTrue((!(jsonMapper.getFactory() instanceof CBORFactory) ? 1 : 0) != 0, (String)"factory of jsonMapper must be JsonFactory.");
        AssertUtil.isTrue((boolean)(cborMapper.getFactory() instanceof CBORFactory), (String)"factory of cborMapper must be CBORFactory.");
        this.jsonConverter = new JsonConverter(jsonMapper, cborMapper);
        this.cborConverter = this.jsonConverter.getCborConverter();
    }

    public ObjectConverter() {
        this.jsonConverter = new JsonConverter();
        this.cborConverter = this.jsonConverter.getCborConverter();
    }

    @Deprecated
    public ObjectConverter(JsonConverter jsonConverter, CborConverter cborConverter) {
        this.jsonConverter = jsonConverter;
        this.cborConverter = cborConverter;
    }

    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    public CborConverter getCborConverter() {
        return this.cborConverter;
    }
}

