/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.fasterxml.jackson.core.type.TypeReference;
import com.webauthn4j.converter.AuthenticationExtensionsClientOutputsConverter;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.AuthenticatorAssertionResponse;
import com.webauthn4j.data.PublicKeyCredential;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.AuthenticationDataVerifier;
import com.webauthn4j.verifier.CustomAuthenticationVerifier;
import com.webauthn4j.verifier.exception.VerificationException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthnAuthenticationManager {
    private final Logger logger = LoggerFactory.getLogger(WebAuthnAuthenticationManager.class);
    private final CollectedClientDataConverter collectedClientDataConverter;
    private final AuthenticatorDataConverter authenticatorDataConverter;
    private final AuthenticationExtensionsClientOutputsConverter authenticationExtensionsClientOutputsConverter;
    private final AuthenticationDataVerifier authenticationDataVerifier;
    private final ObjectConverter objectConverter;

    public WebAuthnAuthenticationManager(@NotNull List<CustomAuthenticationVerifier> customAuthenticationVerifiers, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(customAuthenticationVerifiers, (String)"customAuthenticationVerifiers must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.authenticationDataVerifier = new AuthenticationDataVerifier(customAuthenticationVerifiers);
        this.collectedClientDataConverter = new CollectedClientDataConverter(objectConverter);
        this.authenticatorDataConverter = new AuthenticatorDataConverter(objectConverter);
        this.authenticationExtensionsClientOutputsConverter = new AuthenticationExtensionsClientOutputsConverter(objectConverter);
        this.objectConverter = objectConverter;
    }

    public WebAuthnAuthenticationManager(@NotNull List<CustomAuthenticationVerifier> customAuthenticationVerifiers) {
        this(customAuthenticationVerifiers, new ObjectConverter());
    }

    public WebAuthnAuthenticationManager() {
        this(Collections.emptyList(), new ObjectConverter());
    }

    @NotNull
    public AuthenticationData parse(@NotNull String authenticationResponseJSON) {
        PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput> publicKeyCredential = this.objectConverter.getJsonConverter().readValue(authenticationResponseJSON, new TypeReference<PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput>>(){});
        return this.toAuthenticationData(publicKeyCredential);
    }

    @NotNull
    public AuthenticationData parse(@NotNull InputStream authenticationResponseJSON) {
        PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput> publicKeyCredential = this.objectConverter.getJsonConverter().readValue(authenticationResponseJSON, new TypeReference<PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput>>(){});
        return this.toAuthenticationData(publicKeyCredential);
    }

    @NotNull
    private AuthenticationData toAuthenticationData(@NotNull PublicKeyCredential<AuthenticatorAssertionResponse, AuthenticationExtensionClientOutput> publicKeyCredential) {
        byte[] credentialId = publicKeyCredential.getRawId();
        byte[] userHandle = publicKeyCredential.getResponse().getUserHandle();
        byte[] clientDataBytes = publicKeyCredential.getResponse().getClientDataJSON();
        CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
        byte[] authenticatorDataBytes = publicKeyCredential.getResponse().getAuthenticatorData();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticatorDataBytes == null ? null : this.authenticatorDataConverter.convert(authenticatorDataBytes);
        AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = publicKeyCredential.getClientExtensionResults();
        byte[] signature = publicKeyCredential.getResponse().getSignature();
        return new AuthenticationData(credentialId, userHandle, authenticatorData, authenticatorDataBytes, collectedClientData, clientDataBytes, clientExtensions, signature);
    }

    @NotNull
    public AuthenticationData parse(@NotNull AuthenticationRequest authenticationRequest) throws DataConversionException {
        AssertUtil.notNull((Object)authenticationRequest, (String)"authenticationRequest must not be null");
        this.logger.trace("Parse: {}", (Object)authenticationRequest);
        byte[] credentialId = authenticationRequest.getCredentialId();
        byte[] signature = authenticationRequest.getSignature();
        byte[] userHandle = authenticationRequest.getUserHandle();
        byte[] clientDataBytes = authenticationRequest.getClientDataJSON();
        CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
        byte[] authenticatorDataBytes = authenticationRequest.getAuthenticatorData();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticatorDataBytes == null ? null : this.authenticatorDataConverter.convert(authenticatorDataBytes);
        AuthenticationExtensionsClientOutputs<AuthenticationExtensionClientOutput> clientExtensions = authenticationRequest.getClientExtensionsJSON() == null ? null : this.authenticationExtensionsClientOutputsConverter.convert(authenticationRequest.getClientExtensionsJSON());
        return new AuthenticationData(credentialId, userHandle, authenticatorData, authenticatorDataBytes, collectedClientData, clientDataBytes, clientExtensions, signature);
    }

    @NotNull
    public AuthenticationData verify(@NotNull String authenticationResponseJSON, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        AuthenticationData authenticationData = this.parse(authenticationResponseJSON);
        return this.verify(authenticationData, authenticationParameters);
    }

    @NotNull
    public AuthenticationData verify(@NotNull InputStream authenticationResponseJSON, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        AuthenticationData authenticationData = this.parse(authenticationResponseJSON);
        return this.verify(authenticationData, authenticationParameters);
    }

    @NotNull
    public AuthenticationData verify(@NotNull AuthenticationRequest authenticationRequest, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, VerificationException {
        AuthenticationData authenticationData = this.parse(authenticationRequest);
        this.verify(authenticationData, authenticationParameters);
        return authenticationData;
    }

    @NotNull
    public AuthenticationData verify(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) throws VerificationException {
        this.logger.trace("Verify: {}, {}", (Object)authenticationData, (Object)authenticationParameters);
        this.authenticationDataVerifier.verify(authenticationData, authenticationParameters);
        return authenticationData;
    }

    @NotNull
    public AuthenticationDataVerifier getAuthenticationDataVerifier() {
        return this.authenticationDataVerifier;
    }
}

