/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.webauthn4j.converter.jackson.deserializer.json.AttachmentHintFromLongDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.AuthenticationAlgorithmFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.AuthenticatorAttestationTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.ByteArrayBase64UrlDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.ChallengeDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.CredentialProtectionPolicyDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.JWSHeaderDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.KeyProtectionTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.MatcherProtectionTypeFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.PublicKeyRepresentationFormatFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.TransactionConfirmationDisplayFromIntDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.UserVerificationMethodFromLongDeserializer;
import com.webauthn4j.converter.jackson.deserializer.json.X509CertificateDeserializer;
import com.webauthn4j.converter.jackson.serializer.json.AttachmentHintToLongSerializer;
import com.webauthn4j.converter.jackson.serializer.json.AuthenticationAlgorithmToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.AuthenticatorAttestationTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.ByteArrayBase64UrlSerializer;
import com.webauthn4j.converter.jackson.serializer.json.ChallengeSerializer;
import com.webauthn4j.converter.jackson.serializer.json.CredentialProtectionPolicySerializer;
import com.webauthn4j.converter.jackson.serializer.json.JWSHeaderSerializer;
import com.webauthn4j.converter.jackson.serializer.json.KeyProtectionTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.MatcherProtectionTypeToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.OriginSerializer;
import com.webauthn4j.converter.jackson.serializer.json.PublicKeyRepresentationFormatToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.TransactionConfirmationDisplayToIntSerializer;
import com.webauthn4j.converter.jackson.serializer.json.UserVerificationMethodToLongSerializer;
import com.webauthn4j.converter.jackson.serializer.json.X509CertificateSerializer;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AttachmentHint;
import com.webauthn4j.data.AuthenticationAlgorithm;
import com.webauthn4j.data.AuthenticatorAttestationType;
import com.webauthn4j.data.KeyProtectionType;
import com.webauthn4j.data.MatcherProtectionType;
import com.webauthn4j.data.PublicKeyRepresentationFormat;
import com.webauthn4j.data.TransactionConfirmationDisplay;
import com.webauthn4j.data.UserVerificationMethod;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.util.AssertUtil;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;

public class WebAuthnJSONModule
extends SimpleModule {
    public WebAuthnJSONModule(@NotNull ObjectConverter objectConverter) {
        super("WebAuthnJSONModule");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.addDeserializer(AttachmentHint.class, (JsonDeserializer)new AttachmentHintFromLongDeserializer());
        this.addDeserializer(AuthenticatorAttestationType.class, (JsonDeserializer)new AuthenticatorAttestationTypeFromIntDeserializer());
        this.addDeserializer(AuthenticationAlgorithm.class, (JsonDeserializer)new AuthenticationAlgorithmFromIntDeserializer());
        this.addDeserializer(Challenge.class, (JsonDeserializer)new ChallengeDeserializer());
        this.addDeserializer(CredentialProtectionPolicy.class, (JsonDeserializer)new CredentialProtectionPolicyDeserializer());
        this.addDeserializer(JWSHeader.class, (JsonDeserializer)new JWSHeaderDeserializer());
        this.addDeserializer(KeyProtectionType.class, (JsonDeserializer)new KeyProtectionTypeFromIntDeserializer());
        this.addDeserializer(MatcherProtectionType.class, (JsonDeserializer)new MatcherProtectionTypeFromIntDeserializer());
        this.addDeserializer(PublicKeyRepresentationFormat.class, (JsonDeserializer)new PublicKeyRepresentationFormatFromIntDeserializer());
        this.addDeserializer(TransactionConfirmationDisplay.class, (JsonDeserializer)new TransactionConfirmationDisplayFromIntDeserializer());
        this.addDeserializer(UserVerificationMethod.class, (JsonDeserializer)new UserVerificationMethodFromLongDeserializer());
        this.addDeserializer(X509Certificate.class, (JsonDeserializer)new X509CertificateDeserializer());
        this.addDeserializer(byte[].class, (JsonDeserializer)new ByteArrayBase64UrlDeserializer());
        this.addSerializer(AttachmentHint.class, (JsonSerializer)new AttachmentHintToLongSerializer());
        this.addSerializer(AuthenticatorAttestationType.class, (JsonSerializer)new AuthenticatorAttestationTypeToIntSerializer());
        this.addSerializer(AuthenticationAlgorithm.class, (JsonSerializer)new AuthenticationAlgorithmToIntSerializer());
        this.addSerializer((JsonSerializer)new ChallengeSerializer());
        this.addSerializer((JsonSerializer)new CredentialProtectionPolicySerializer());
        this.addSerializer((JsonSerializer)new JWSHeaderSerializer());
        this.addSerializer((JsonSerializer)new KeyProtectionTypeToIntSerializer());
        this.addSerializer((JsonSerializer)new MatcherProtectionTypeToIntSerializer());
        this.addSerializer((JsonSerializer)new OriginSerializer());
        this.addSerializer(PublicKeyRepresentationFormat.class, (JsonSerializer)new PublicKeyRepresentationFormatToIntSerializer());
        this.addSerializer(TransactionConfirmationDisplay.class, (JsonSerializer)new TransactionConfirmationDisplayToIntSerializer());
        this.addSerializer(UserVerificationMethod.class, (JsonSerializer)new UserVerificationMethodToLongSerializer());
        this.addSerializer((JsonSerializer)new X509CertificateSerializer());
        this.addSerializer((JsonSerializer)new ByteArrayBase64UrlSerializer());
    }
}

