/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.attestation.statement.apple;

import com.webauthn4j.data.attestation.statement.AppleAnonymousAttestationStatement;
import com.webauthn4j.data.attestation.statement.AttestationType;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import com.webauthn4j.verifier.attestation.statement.AbstractStatementVerifier;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import com.webauthn4j.verifier.exception.PublicKeyMismatchException;
import com.webauthn4j.verifier.internal.asn1.ASN1Primitive;
import com.webauthn4j.verifier.internal.asn1.ASN1Structure;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class AppleAnonymousAttestationStatementVerifier
extends AbstractStatementVerifier<AppleAnonymousAttestationStatement> {
    @Override
    @NotNull
    public AttestationType verify(@NotNull CoreRegistrationObject registrationObject) {
        AssertUtil.notNull((Object)registrationObject, (String)"registrationObject must not be null");
        if (!this.supports(registrationObject)) {
            throw new IllegalArgumentException(String.format("Specified format '%s' is not supported by %s.", registrationObject.getAttestationObject().getFormat(), this.getClass().getName()));
        }
        AppleAnonymousAttestationStatement attestationStatement = (AppleAnonymousAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        this.verifyAttestationStatementNotNull(attestationStatement);
        this.verifyNonce(registrationObject);
        this.verifyPublicKey(registrationObject, attestationStatement);
        return AttestationType.BASIC;
    }

    void verifyAttestationStatementNotNull(AppleAnonymousAttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new BadAttestationStatementException("attestation statement is not found.");
        }
    }

    private void verifyNonce(@NotNull CoreRegistrationObject registrationObject) {
        AppleAnonymousAttestationStatement attestationStatement = (AppleAnonymousAttestationStatement)registrationObject.getAttestationObject().getAttestationStatement();
        byte[] nonce = this.getNonce(registrationObject);
        byte[] extracted = this.extractNonce(attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate());
        if (!Arrays.equals(extracted, nonce)) {
            throw new BadAttestationStatementException("nonce doesn't match.");
        }
    }

    @NotNull
    private byte[] getNonce(@NotNull CoreRegistrationObject registrationObject) {
        byte[] authenticatorData = registrationObject.getAuthenticatorDataBytes();
        byte[] clientDataHash = registrationObject.getClientDataHash();
        byte[] nonceToHash = ByteBuffer.allocate(authenticatorData.length + clientDataHash.length).put(authenticatorData).put(clientDataHash).array();
        return MessageDigestUtil.createSHA256().digest(nonceToHash);
    }

    private void verifyPublicKey(@NotNull CoreRegistrationObject registrationObject, @NotNull AppleAnonymousAttestationStatement attestationStatement) {
        PublicKey publicKeyInCredentialData;
        PublicKey publicKeyInEndEntityCert = attestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey();
        if (!publicKeyInEndEntityCert.equals(publicKeyInCredentialData = registrationObject.getAttestationObject().getAuthenticatorData().getAttestedCredentialData().getCOSEKey().getPublicKey())) {
            throw new PublicKeyMismatchException("The public key in the first certificate in x5c doesn't matches the credentialPublicKey in the attestedCredentialData in authenticatorData.");
        }
    }

    private byte[] extractNonce(X509Certificate attestationCertificate) {
        byte[] extensionValue = attestationCertificate.getExtensionValue("1.2.840.113635.100.8.2");
        if (extensionValue == null) {
            throw new BadAttestationStatementException("Apple X.509 extension not found");
        }
        try {
            ASN1Primitive extensionEnvelope = ASN1Primitive.parse(extensionValue);
            ASN1Structure sequence = extensionEnvelope.getValueAsASN1Structure();
            ASN1Structure innerSequence = (ASN1Structure)sequence.get(0);
            ASN1Primitive firstItem = (ASN1Primitive)innerSequence.get(0);
            return firstItem.getValue();
        }
        catch (RuntimeException e) {
            throw new BadAttestationStatementException("Failed to extract nonce from Apple anonymous attestation statement.", e);
        }
    }
}

