/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="fido-u2f")
public class FIDOU2FAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "fido-u2f";
    @JsonProperty
    private final AttestationCertificatePath x5c;
    @JsonProperty
    private final byte[] sig;

    @JsonCreator
    public FIDOU2FAttestationStatement(@JsonProperty(value="x5c") @NotNull AttestationCertificatePath x5c, @JsonProperty(value="sig") @NotNull byte[] sig) {
        AssertUtil.notNull((Object)x5c, (String)"x5c must not be null");
        AssertUtil.notNull((Object)sig, (String)"sig must not be null");
        this.x5c = x5c;
        this.sig = sig;
    }

    @Override
    @NotNull
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    @NotNull
    public byte[] getSig() {
        return ArrayUtil.clone((byte[])this.sig);
    }

    @Override
    @NotNull
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.x5c.size() != 1) {
            throw new ConstraintViolationException("x5c must have exactly one certificate");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FIDOU2FAttestationStatement that = (FIDOU2FAttestationStatement)o;
        return Objects.equals(this.x5c, that.x5c) && Arrays.equals(this.sig, that.sig);
    }

    public int hashCode() {
        int result = Objects.hash(this.x5c);
        result = 31 * result + Arrays.hashCode(this.sig);
        return result;
    }

    public String toString() {
        return "FIDOU2FAttestationStatement(x5c=" + this.x5c + ", sig=" + ArrayUtil.toHexString((byte[])this.sig) + ")";
    }
}

