/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.internal;

import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.SignatureAlgorithm;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.exception.BadSignatureException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionSignatureVerifier {
    private final Logger logger = LoggerFactory.getLogger(AssertionSignatureVerifier.class);

    public void verify(@NotNull CoreAuthenticationData authenticationData, @NotNull COSEKey coseKey) {
        AssertUtil.notNull((Object)authenticationData, (String)"authenticationData must not be null");
        AssertUtil.notNull((Object)coseKey, (String)"coseKey must not be null");
        byte[] signedData = this.getSignedData(authenticationData);
        byte[] signature = authenticationData.getSignature();
        if (!this.verifySignature(coseKey, signature, signedData)) {
            throw new BadSignatureException("Assertion signature is not valid.");
        }
    }

    @NotNull
    protected byte[] getSignedData(@NotNull CoreAuthenticationData authenticationData) {
        byte[] rawAuthenticatorData = authenticationData.getAuthenticatorDataBytes();
        byte[] clientDataHash = authenticationData.getClientDataHash();
        return ByteBuffer.allocate(rawAuthenticatorData.length + clientDataHash.length).put(rawAuthenticatorData).put(clientDataHash).array();
    }

    private boolean verifySignature(@NotNull COSEKey coseKey, @NotNull byte[] signature, @NotNull byte[] data) {
        try {
            PublicKey publicKey = coseKey.getPublicKey();
            SignatureAlgorithm signatureAlgorithm = coseKey.getAlgorithm().toSignatureAlgorithm();
            String jcaName = signatureAlgorithm.getJcaName();
            Signature verifier = Signature.getInstance(jcaName);
            verifier.initVerify(publicKey);
            verifier.update(data);
            return verifier.verify(signature);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("COSE key alg must be signature algorithm.", (Throwable)e);
            return false;
        }
        catch (RuntimeException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            this.logger.debug("Unexpected exception is thrown during signature verification.", (Throwable)e);
            return false;
        }
    }
}

