/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.AttestedCredentialDataConverter;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthenticatorAttestationResponse
extends AuthenticatorResponse {
    private final byte[] attestationObject;
    private final Set<AuthenticatorTransport> transports;

    public AuthenticatorAttestationResponse(@NotNull byte[] clientDataJSON, @NotNull byte[] attestationObject) {
        this(clientDataJSON, attestationObject, Collections.emptySet());
    }

    @JsonCreator
    public AuthenticatorAttestationResponse(@JsonProperty(value="clientDataJSON") @NotNull byte[] clientDataJSON, @JsonProperty(value="attestationObject") @NotNull byte[] attestationObject, @JsonProperty(value="transports") @Nullable Set<AuthenticatorTransport> transports) {
        super(clientDataJSON);
        AssertUtil.notNull((Object)attestationObject, (String)"attestationObject must not be null");
        this.attestationObject = attestationObject;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    @NotNull
    public byte[] getAttestationObject() {
        return ArrayUtil.clone((byte[])this.attestationObject);
    }

    @NotNull
    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    @NotNull
    public byte[] getAuthenticatorData(ObjectConverter objectConverter) {
        AttestationObjectConverter attestationObjectConverter = new AttestationObjectConverter(objectConverter);
        return attestationObjectConverter.extractAuthenticatorData(this.attestationObject);
    }

    @NotNull
    public byte[] getAuthenticatorData() {
        return this.getAuthenticatorData(new ObjectConverter());
    }

    @Nullable
    public byte[] getPublicKey(ObjectConverter objectConverter) {
        return this.getCOSEKey(objectConverter).getPublicKey().getEncoded();
    }

    @Nullable
    public byte[] getPublicKey() {
        return this.getPublicKey(new ObjectConverter());
    }

    @Nullable
    public COSEAlgorithmIdentifier getPublicKeyAlgorithm(ObjectConverter objectConverter) {
        return this.getCOSEKey(objectConverter).getAlgorithm();
    }

    @Nullable
    public COSEAlgorithmIdentifier getPublicKeyAlgorithm() {
        return this.getCOSEKey(new ObjectConverter()).getAlgorithm();
    }

    @NotNull
    private COSEKey getCOSEKey(ObjectConverter objectConverter) {
        AuthenticatorDataConverter authenticatorDataConverter = new AuthenticatorDataConverter(objectConverter);
        AttestedCredentialDataConverter attestedCredentialDataConverter = new AttestedCredentialDataConverter(objectConverter);
        byte[] attestedCredentialDataBytes = authenticatorDataConverter.extractAttestedCredentialData(this.getAuthenticatorData(objectConverter));
        AttestedCredentialData attestedCredentialData = attestedCredentialDataConverter.convert(attestedCredentialDataBytes);
        return attestedCredentialData.getCOSEKey();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorAttestationResponse that = (AuthenticatorAttestationResponse)o;
        return Arrays.equals(this.attestationObject, that.attestationObject) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.transports);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        return result;
    }

    @Override
    public String toString() {
        return "AuthenticatorAttestationResponse(attestationObject=" + ArrayUtil.toHexString((byte[])this.attestationObject) + ", transports=" + this.transports + ")";
    }
}

