/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.AbstractCOSEKey;
import com.webauthn4j.data.attestation.authenticator.Curve;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.COSEKeyOperation;
import com.webauthn4j.data.attestation.statement.COSEKeyType;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.ECUtil;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EC2COSEKey
extends AbstractCOSEKey {
    private static final String CURVE_NULL_CHECK_MESSAGE = "curve must not be null";
    @JsonProperty(value="-1")
    private final Curve curve;
    @JsonProperty(value="-2")
    private byte[] x;
    @JsonProperty(value="-3")
    private byte[] y;
    @JsonProperty(value="-4")
    private byte[] d;

    @JsonCreator
    public EC2COSEKey(@JsonProperty(value="2") @Nullable byte[] keyId, @JsonProperty(value="3") @Nullable COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") @Nullable List<COSEKeyOperation> keyOps, @JsonProperty(value="-1") @Nullable Curve curve, @JsonProperty(value="-2") @Nullable byte[] x, @JsonProperty(value="-3") @Nullable byte[] y, @JsonProperty(value="-4") @Nullable byte[] d) {
        super(keyId, algorithm, keyOps, null);
        this.curve = curve;
        this.x = x;
        this.y = y;
        this.d = d;
    }

    public EC2COSEKey(@JsonProperty(value="2") @Nullable byte[] keyId, @JsonProperty(value="3") @Nullable COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") @Nullable List<COSEKeyOperation> keyOps, @JsonProperty(value="-1") @Nullable Curve curve, @JsonProperty(value="-2") @Nullable byte[] x, @JsonProperty(value="-3") @Nullable byte[] y) {
        super(keyId, algorithm, keyOps, null);
        this.curve = curve;
        this.x = x;
        this.y = y;
    }

    public EC2COSEKey(@JsonProperty(value="2") @Nullable byte[] keyId, @JsonProperty(value="3") @Nullable COSEAlgorithmIdentifier algorithm, @JsonProperty(value="4") @Nullable List<COSEKeyOperation> keyOps, @JsonProperty(value="-1") @Nullable Curve curve, @JsonProperty(value="-2") @Nullable byte[] d) {
        super(keyId, algorithm, keyOps, null);
        this.curve = curve;
        this.d = d;
    }

    @NotNull
    public static EC2COSEKey create(@NotNull ECPrivateKey privateKey, @Nullable COSEAlgorithmIdentifier alg) {
        AssertUtil.notNull((Object)privateKey, (String)"privateKey must not be null");
        Curve curve = EC2COSEKey.getCurve(privateKey.getParams());
        byte[] d = privateKey.getS().toByteArray();
        return new EC2COSEKey(null, alg, null, curve, null, null, d);
    }

    @NotNull
    public static EC2COSEKey create(@NotNull ECPublicKey publicKey, @Nullable COSEAlgorithmIdentifier alg) {
        AssertUtil.notNull((Object)publicKey, (String)"publicKey must not be null");
        ECPoint ecPoint = publicKey.getW();
        Curve curve = EC2COSEKey.getCurve(publicKey.getParams());
        byte[] x = ArrayUtil.convertToFixedByteArray((int)curve.getSize(), (BigInteger)ecPoint.getAffineX());
        byte[] y = ArrayUtil.convertToFixedByteArray((int)curve.getSize(), (BigInteger)ecPoint.getAffineY());
        return new EC2COSEKey(null, alg, null, curve, x, y);
    }

    @NotNull
    public static EC2COSEKey create(@NotNull KeyPair keyPair, @Nullable COSEAlgorithmIdentifier alg) {
        AssertUtil.notNull((Object)keyPair, (String)"keyPair must not be null");
        if (keyPair.getPrivate() instanceof ECPrivateKey && keyPair.getPublic() instanceof ECPublicKey) {
            ECPrivateKey ecPrivateKey = (ECPrivateKey)keyPair.getPrivate();
            ECPublicKey ecPublicKey = (ECPublicKey)keyPair.getPublic();
            ECPoint ecPoint = ecPublicKey.getW();
            Curve curve = EC2COSEKey.getCurve(ecPrivateKey.getParams());
            byte[] x = ArrayUtil.convertToFixedByteArray((int)curve.getSize(), (BigInteger)ecPoint.getAffineX());
            byte[] y = ArrayUtil.convertToFixedByteArray((int)curve.getSize(), (BigInteger)ecPoint.getAffineY());
            byte[] d = ecPrivateKey.getS().toByteArray();
            return new EC2COSEKey(null, alg, null, curve, x, y, d);
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    public static EC2COSEKey create(@NotNull ECPrivateKey privateKey) {
        return EC2COSEKey.create(privateKey, null);
    }

    @NotNull
    public static EC2COSEKey create(@NotNull ECPublicKey publicKey) {
        return EC2COSEKey.create(publicKey, null);
    }

    @NotNull
    public static EC2COSEKey create(@NotNull KeyPair keyPair) {
        return EC2COSEKey.create(keyPair, null);
    }

    @NotNull
    public static EC2COSEKey createFromUncompressedECCKey(@NotNull byte[] publicKey) {
        if (publicKey.length != 65) {
            throw new IllegalArgumentException("publicKey must be 65 bytes length");
        }
        byte[] x = Arrays.copyOfRange(publicKey, 1, 33);
        byte[] y = Arrays.copyOfRange(publicKey, 33, 65);
        return new EC2COSEKey(null, COSEAlgorithmIdentifier.ES256, null, Curve.SECP256R1, x, y, null);
    }

    @NotNull
    static Curve getCurve(@Nullable ECParameterSpec params) {
        if (params == null) {
            throw new IllegalArgumentException("params must not be null");
        }
        if (params.getCurve().equals(ECUtil.P_256_SPEC.getCurve())) {
            return Curve.SECP256R1;
        }
        if (params.getCurve().equals(ECUtil.P_384_SPEC.getCurve())) {
            return Curve.SECP384R1;
        }
        if (params.getCurve().equals(ECUtil.P_521_SPEC.getCurve())) {
            return Curve.SECP521R1;
        }
        throw new IllegalArgumentException();
    }

    @Override
    @NotNull
    public COSEKeyType getKeyType() {
        return COSEKeyType.EC2;
    }

    @Nullable
    public Curve getCurve() {
        return this.curve;
    }

    @Nullable
    public byte[] getX() {
        return ArrayUtil.clone((byte[])this.x);
    }

    @Nullable
    public byte[] getY() {
        return ArrayUtil.clone((byte[])this.y);
    }

    @Nullable
    public byte[] getD() {
        return ArrayUtil.clone((byte[])this.d);
    }

    @Override
    @Nullable
    public PublicKey getPublicKey() {
        if (!this.hasPublicKey()) {
            return null;
        }
        ECPoint ecPoint = new ECPoint(new BigInteger(1, this.getX()), new BigInteger(1, this.getY()));
        if (this.curve == null) {
            throw new IllegalStateException(CURVE_NULL_CHECK_MESSAGE);
        }
        ECPublicKeySpec spec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)this.curve.getParameterSpec());
        return ECUtil.createPublicKey((ECPublicKeySpec)spec);
    }

    @Override
    @Nullable
    public PrivateKey getPrivateKey() {
        if (!this.hasPrivateKey()) {
            return null;
        }
        BigInteger s = new BigInteger(1, this.d);
        if (this.curve == null) {
            throw new IllegalStateException(CURVE_NULL_CHECK_MESSAGE);
        }
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(s, (ECParameterSpec)this.curve.getParameterSpec());
        return ECUtil.createPrivateKey((ECPrivateKeySpec)ecPrivateKeySpec);
    }

    @Override
    public boolean hasPublicKey() {
        return this.x != null && this.y != null;
    }

    @Override
    public boolean hasPrivateKey() {
        return this.d != null;
    }

    @Override
    public void validate() {
        if (this.getAlgorithm() == null) {
            throw new ConstraintViolationException("algorithm must not be null");
        }
        if (this.curve == null) {
            throw new ConstraintViolationException(CURVE_NULL_CHECK_MESSAGE);
        }
        if (this.d != null) {
            return;
        }
        if (!this.hasPublicKey() && !this.hasPrivateKey()) {
            throw new ConstraintViolationException("x, y or d must be present");
        }
        if (this.x == null) {
            throw new ConstraintViolationException("x must not be null");
        }
        if (this.y == null) {
            throw new ConstraintViolationException("y must not be null");
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EC2COSEKey that = (EC2COSEKey)o;
        return this.curve == that.curve && Arrays.equals(this.x, that.x) && Arrays.equals(this.y, that.y) && Arrays.equals(this.d, that.d);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.curve});
        result = 31 * result + Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        result = 31 * result + Arrays.hashCode(this.d);
        return result;
    }

    public String toString() {
        return "EC2COSEKey(keyId=" + ArrayUtil.toHexString((byte[])this.getKeyId()) + ", alg=" + this.getAlgorithm() + ", curve=" + this.curve + ", x=" + ArrayUtil.toHexString((byte[])this.x) + ", y=" + ArrayUtil.toHexString((byte[])this.y) + ", d=" + ArrayUtil.toHexString((byte[])this.d) + ")";
    }
}

