/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AuthenticatorAttachment {
    public static final AuthenticatorAttachment PLATFORM = new AuthenticatorAttachment("platform");
    public static final AuthenticatorAttachment CROSS_PLATFORM = new AuthenticatorAttachment("cross-platform");
    private final String value;

    private AuthenticatorAttachment(@NotNull String value) {
        this.value = value;
    }

    @JsonCreator
    @NotNull
    public static AuthenticatorAttachment create(@NotNull String value) {
        AssertUtil.notNull((Object)value, (String)"value must not be null.");
        switch (value) {
            case "platform": {
                return PLATFORM;
            }
            case "cross-platform": {
                return CROSS_PLATFORM;
            }
        }
        return new AuthenticatorAttachment(value);
    }

    @JsonValue
    @NotNull
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorAttachment that = (AuthenticatorAttachment)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

