/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.AuthenticationExtensionsClientOutputsConverter;
import com.webauthn4j.converter.AuthenticatorTransportConverter;
import com.webauthn4j.converter.CollectedClientDataConverter;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.CustomRegistrationValidator;
import com.webauthn4j.validator.RegistrationDataValidator;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidkey.NullAndroidKeyAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.apple.NullAppleAnonymousAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.none.NoneAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.packed.NullPackedAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.tpm.NullTPMAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.u2f.NullFIDOU2FAttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.ValidationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthnRegistrationManager {
    private final Logger logger = LoggerFactory.getLogger(WebAuthnRegistrationManager.class);
    private final CollectedClientDataConverter collectedClientDataConverter;
    private final AttestationObjectConverter attestationObjectConverter;
    private final AuthenticatorTransportConverter authenticatorTransportConverter;
    private final AuthenticationExtensionsClientOutputsConverter authenticationExtensionsClientOutputsConverter;
    private final RegistrationDataValidator registrationDataValidator;

    public WebAuthnRegistrationManager(@NotNull List<AttestationStatementValidator> attestationStatementValidators, @NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, @NotNull List<CustomRegistrationValidator> customRegistrationValidators, @NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull(attestationStatementValidators, (String)"attestationStatementValidators must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessValidator, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessValidator, (String)"selfAttestationTrustworthinessValidator must not be null");
        AssertUtil.notNull(customRegistrationValidators, (String)"customRegistrationValidators must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.registrationDataValidator = new RegistrationDataValidator(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator, customRegistrationValidators, objectConverter);
        this.collectedClientDataConverter = new CollectedClientDataConverter(objectConverter);
        this.attestationObjectConverter = new AttestationObjectConverter(objectConverter);
        this.authenticatorTransportConverter = new AuthenticatorTransportConverter();
        this.authenticationExtensionsClientOutputsConverter = new AuthenticationExtensionsClientOutputsConverter(objectConverter);
    }

    public WebAuthnRegistrationManager(@NotNull List<AttestationStatementValidator> attestationStatementValidators, @NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, @NotNull List<CustomRegistrationValidator> customRegistrationValidators) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator, customRegistrationValidators, new ObjectConverter());
    }

    public WebAuthnRegistrationManager(@NotNull List<AttestationStatementValidator> attestationStatementValidators, @NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, @NotNull ObjectConverter objectConverter) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator, Collections.emptyList(), objectConverter);
    }

    public WebAuthnRegistrationManager(@NotNull List<AttestationStatementValidator> attestationStatementValidators, @NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator, Collections.emptyList());
    }

    @NotNull
    public static WebAuthnRegistrationManager createNonStrictWebAuthnRegistrationManager() {
        ObjectConverter objectConverter = new ObjectConverter();
        return WebAuthnRegistrationManager.createNonStrictWebAuthnRegistrationManager(objectConverter);
    }

    @NotNull
    public static WebAuthnRegistrationManager createNonStrictWebAuthnRegistrationManager(@NotNull ObjectConverter objectConverter) {
        return new WebAuthnRegistrationManager(Arrays.asList(new NoneAttestationStatementValidator(), new NullFIDOU2FAttestationStatementValidator(), new NullPackedAttestationStatementValidator(), new NullTPMAttestationStatementValidator(), new NullAndroidKeyAttestationStatementValidator(), new NullAndroidSafetyNetAttestationStatementValidator(), new NullAppleAnonymousAttestationStatementValidator()), (CertPathTrustworthinessValidator)new NullCertPathTrustworthinessValidator(), (SelfAttestationTrustworthinessValidator)new NullSelfAttestationTrustworthinessValidator(), objectConverter);
    }

    @NotNull
    public RegistrationData parse(@NotNull RegistrationRequest registrationRequest) throws DataConversionException {
        AssertUtil.notNull((Object)registrationRequest, (String)"registrationRequest must not be null");
        byte[] clientDataBytes = registrationRequest.getClientDataJSON();
        byte[] attestationObjectBytes = registrationRequest.getAttestationObject();
        this.logger.trace("Parse: {}", (Object)registrationRequest);
        CollectedClientData collectedClientData = clientDataBytes == null ? null : this.collectedClientDataConverter.convert(clientDataBytes);
        AttestationObject attestationObject = attestationObjectBytes == null ? null : this.attestationObjectConverter.convert(attestationObjectBytes);
        Set<AuthenticatorTransport> transports = registrationRequest.getTransports() == null ? null : this.authenticatorTransportConverter.convertSet(registrationRequest.getTransports());
        AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions = registrationRequest.getClientExtensionsJSON() == null ? null : this.authenticationExtensionsClientOutputsConverter.convert(registrationRequest.getClientExtensionsJSON());
        return new RegistrationData(attestationObject, attestationObjectBytes, collectedClientData, clientDataBytes, clientExtensions, transports);
    }

    @NotNull
    public RegistrationData validate(@NotNull RegistrationRequest registrationRequest, @NotNull RegistrationParameters registrationParameters) throws DataConversionException, ValidationException {
        RegistrationData registrationData = this.parse(registrationRequest);
        return this.validate(registrationData, registrationParameters);
    }

    @NotNull
    public RegistrationData validate(@NotNull RegistrationData registrationData, @NotNull RegistrationParameters registrationParameters) throws ValidationException {
        this.logger.trace("Validate: {}, {}", (Object)registrationData, (Object)registrationParameters);
        this.registrationDataValidator.validate(registrationData, registrationParameters);
        return registrationData;
    }

    @NotNull
    public RegistrationDataValidator getRegistrationDataValidator() {
        return this.registrationDataValidator;
    }
}

