/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j;

import com.webauthn4j.WebAuthnAuthenticationManager;
import com.webauthn4j.WebAuthnRegistrationManager;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.validator.AuthenticationDataValidator;
import com.webauthn4j.validator.CustomAuthenticationValidator;
import com.webauthn4j.validator.CustomRegistrationValidator;
import com.webauthn4j.validator.RegistrationDataValidator;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidkey.NullAndroidKeyAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.androidsafetynet.NullAndroidSafetyNetAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.apple.NullAppleAnonymousAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.none.NoneAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.packed.NullPackedAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.tpm.NullTPMAttestationStatementValidator;
import com.webauthn4j.validator.attestation.statement.u2f.NullFIDOU2FAttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.NullCertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.NullSelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.ValidationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebAuthnManager {
    private final WebAuthnRegistrationManager webAuthnRegistrationManager;
    private final WebAuthnAuthenticationManager webAuthnAuthenticationManager;

    public WebAuthnManager(@NotNull List<AttestationStatementValidator> attestationStatementValidators, @NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, @NotNull List<CustomRegistrationValidator> customRegistrationValidators, @NotNull List<CustomAuthenticationValidator> customAuthenticationValidators, @NotNull ObjectConverter objectConverter) {
        this.webAuthnRegistrationManager = new WebAuthnRegistrationManager(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator, customRegistrationValidators, objectConverter);
        this.webAuthnAuthenticationManager = new WebAuthnAuthenticationManager(customAuthenticationValidators, objectConverter);
    }

    public WebAuthnManager(@NotNull List<AttestationStatementValidator> attestationStatementValidators, @NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, @NotNull List<CustomRegistrationValidator> customRegistrationValidators, @NotNull List<CustomAuthenticationValidator> customAuthenticationValidators) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator, customRegistrationValidators, customAuthenticationValidators, new ObjectConverter());
    }

    public WebAuthnManager(@NotNull List<AttestationStatementValidator> attestationStatementValidators, @NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, @NotNull ObjectConverter objectConverter) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator, new ArrayList<CustomRegistrationValidator>(), new ArrayList<CustomAuthenticationValidator>(), objectConverter);
    }

    public WebAuthnManager(@NotNull List<AttestationStatementValidator> attestationStatementValidators, @NotNull CertPathTrustworthinessValidator certPathTrustworthinessValidator, @NotNull SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator) {
        this(attestationStatementValidators, certPathTrustworthinessValidator, selfAttestationTrustworthinessValidator, new ArrayList<CustomRegistrationValidator>(), new ArrayList<CustomAuthenticationValidator>());
    }

    @NotNull
    public static WebAuthnManager createNonStrictWebAuthnManager() {
        ObjectConverter objectConverter = new ObjectConverter();
        return WebAuthnManager.createNonStrictWebAuthnManager(objectConverter);
    }

    @NotNull
    public static WebAuthnManager createNonStrictWebAuthnManager(@NotNull ObjectConverter objectConverter) {
        return new WebAuthnManager(Arrays.asList(new NoneAttestationStatementValidator(), new NullFIDOU2FAttestationStatementValidator(), new NullPackedAttestationStatementValidator(), new NullTPMAttestationStatementValidator(), new NullAndroidKeyAttestationStatementValidator(), new NullAndroidSafetyNetAttestationStatementValidator(), new NullAppleAnonymousAttestationStatementValidator()), new NullCertPathTrustworthinessValidator(), new NullSelfAttestationTrustworthinessValidator(), objectConverter);
    }

    @NotNull
    public RegistrationData parse(@NotNull RegistrationRequest registrationRequest) throws DataConversionException {
        return this.webAuthnRegistrationManager.parse(registrationRequest);
    }

    @NotNull
    public RegistrationData validate(@NotNull RegistrationRequest registrationRequest, @NotNull RegistrationParameters registrationParameters) throws DataConversionException, ValidationException {
        return this.webAuthnRegistrationManager.validate(registrationRequest, registrationParameters);
    }

    @NotNull
    public RegistrationData validate(@NotNull RegistrationData registrationData, @NotNull RegistrationParameters registrationParameters) throws ValidationException {
        return this.webAuthnRegistrationManager.validate(registrationData, registrationParameters);
    }

    @NotNull
    public AuthenticationData parse(@NotNull AuthenticationRequest authenticationRequest) throws DataConversionException {
        return this.webAuthnAuthenticationManager.parse(authenticationRequest);
    }

    @NotNull
    public AuthenticationData validate(@NotNull AuthenticationRequest authenticationRequest, @NotNull AuthenticationParameters authenticationParameters) throws DataConversionException, ValidationException {
        return this.webAuthnAuthenticationManager.validate(authenticationRequest, authenticationParameters);
    }

    @NotNull
    public AuthenticationData validate(@NotNull AuthenticationData authenticationData, @NotNull AuthenticationParameters authenticationParameters) throws ValidationException {
        return this.webAuthnAuthenticationManager.validate(authenticationData, authenticationParameters);
    }

    @NotNull
    public RegistrationDataValidator getRegistrationDataValidator() {
        return this.webAuthnRegistrationManager.getRegistrationDataValidator();
    }

    @NotNull
    public AuthenticationDataValidator getAuthenticationDataValidator() {
        return this.webAuthnAuthenticationManager.getAuthenticationDataValidator();
    }
}

