/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.data.CoreAuthenticationData;
import com.webauthn4j.data.CoreAuthenticationParameters;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AssertionSignatureValidator;
import com.webauthn4j.validator.AuthenticatorExtensionValidator;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.CoreAuthenticationObject;
import com.webauthn4j.validator.CoreMaliciousCounterValueHandler;
import com.webauthn4j.validator.CustomCoreAuthenticationValidator;
import com.webauthn4j.validator.DefaultCoreMaliciousCounterValueHandler;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.NotAllowedCredentialIdException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreAuthenticationDataValidator {
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final AuthenticatorExtensionValidator authenticatorExtensionValidator = new AuthenticatorExtensionValidator();
    private final List<CustomCoreAuthenticationValidator> customAuthenticationValidators;
    private AssertionSignatureValidator assertionSignatureValidator = new AssertionSignatureValidator();
    private CoreMaliciousCounterValueHandler coreMaliciousCounterValueHandler = new DefaultCoreMaliciousCounterValueHandler();

    public CoreAuthenticationDataValidator(@NotNull List<CustomCoreAuthenticationValidator> customAuthenticationValidators) {
        this.customAuthenticationValidators = customAuthenticationValidators;
    }

    public CoreAuthenticationDataValidator() {
        this(new ArrayList<CustomCoreAuthenticationValidator>());
    }

    protected CoreAuthenticationDataValidator(@NotNull List<CustomCoreAuthenticationValidator> customAuthenticationValidators, @NotNull AssertionSignatureValidator assertionSignatureValidator) {
        AssertUtil.notNull(customAuthenticationValidators, (String)"customAuthenticationValidators must not be null");
        AssertUtil.notNull((Object)assertionSignatureValidator, (String)"assertionSignatureValidator must not be null");
        this.customAuthenticationValidators = customAuthenticationValidators;
        this.assertionSignatureValidator = assertionSignatureValidator;
    }

    public void validate(@NotNull CoreAuthenticationData authenticationData, @NotNull CoreAuthenticationParameters authenticationParameters) {
        BeanAssertUtil.validate(authenticationData);
        AssertUtil.notNull((Object)authenticationParameters, (String)"authenticationParameters must not be null");
        byte[] credentialId = authenticationData.getCredentialId();
        List<byte[]> allowCredentials = authenticationParameters.getAllowCredentials();
        this.validateCredentialId(credentialId, allowCredentials);
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        CoreServerProperty serverProperty = authenticationParameters.getServerProperty();
        BeanAssertUtil.validate(authenticatorData);
        this.validateAuthenticatorData(authenticatorData);
        CoreAuthenticator authenticator = authenticationParameters.getAuthenticator();
        CoreAuthenticationObject authenticationObject = this.createCoreAuthenticationObject(authenticationData, authenticationParameters);
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        if (authenticationParameters.isUserPresenceRequired() && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
        if (authenticationParameters.isUserVerificationRequired() && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        AuthenticationExtensionsAuthenticatorOutputs<AuthenticationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        this.authenticatorExtensionValidator.validate(authenticationExtensionsAuthenticatorOutputs);
        this.assertionSignatureValidator.validate(authenticationData, authenticator.getAttestedCredentialData().getCOSEKey());
        long presentedSignCount = authenticatorData.getSignCount();
        long storedSignCount = authenticator.getCounter();
        if (presentedSignCount > 0L || storedSignCount > 0L) {
            if (presentedSignCount > storedSignCount) {
                authenticator.setCounter(presentedSignCount);
            } else {
                this.coreMaliciousCounterValueHandler.maliciousCounterValueDetected(authenticationObject);
            }
        }
        for (CustomCoreAuthenticationValidator customAuthenticationValidator : this.customAuthenticationValidators) {
            customAuthenticationValidator.validate(authenticationObject);
        }
    }

    @NotNull
    protected CoreAuthenticationObject createCoreAuthenticationObject(@NotNull CoreAuthenticationData authenticationData, @NotNull CoreAuthenticationParameters authenticationParameters) {
        byte[] credentialId = authenticationData.getCredentialId();
        AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData = authenticationData.getAuthenticatorData();
        byte[] authenticatorDataBytes = authenticationData.getAuthenticatorDataBytes();
        byte[] clientDataHash = authenticationData.getClientDataHash();
        CoreServerProperty serverProperty = authenticationParameters.getServerProperty();
        CoreAuthenticator authenticator = authenticationParameters.getAuthenticator();
        AssertUtil.notNull(authenticatorData, (String)"authenticatorData must not be null");
        return new CoreAuthenticationObject(credentialId, authenticatorData, authenticatorDataBytes, clientDataHash, serverProperty, authenticator);
    }

    void validateCredentialId(byte[] credentialId, @Nullable List<byte[]> allowCredentials) {
        if (allowCredentials != null && allowCredentials.stream().noneMatch(item -> Arrays.equals(item, credentialId))) {
            throw new NotAllowedCredentialIdException("credentialId not listed in allowCredentials is used.");
        }
    }

    void validateAuthenticatorData(@NotNull AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() != null) {
            throw new ConstraintViolationException("attestedCredentialData must be null on authentication");
        }
    }

    @NotNull
    public CoreMaliciousCounterValueHandler getMaliciousCounterValueHandler() {
        return this.coreMaliciousCounterValueHandler;
    }

    public void setMaliciousCounterValueHandler(@NotNull CoreMaliciousCounterValueHandler coreMaliciousCounterValueHandler) {
        AssertUtil.notNull((Object)coreMaliciousCounterValueHandler, (String)"maliciousCounterValueHandler must not be null");
        this.coreMaliciousCounterValueHandler = coreMaliciousCounterValueHandler;
    }

    @NotNull
    public List<CustomCoreAuthenticationValidator> getCustomAuthenticationValidators() {
        return this.customAuthenticationValidators;
    }
}

