/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.converter.util.JsonConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectedClientDataConverter {
    private final JsonConverter jsonConverter;

    public CollectedClientDataConverter(@NotNull ObjectConverter objectConverter) {
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.jsonConverter = objectConverter.getJsonConverter();
    }

    @Nullable
    public CollectedClientData convert(@NotNull String base64UrlString) {
        try {
            AssertUtil.notNull((Object)base64UrlString, (String)"base64UrlString must not be null");
            byte[] bytes = Base64UrlUtil.decode((String)base64UrlString);
            return this.convert(bytes);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @Nullable
    public CollectedClientData convert(@NotNull byte[] source) {
        try {
            AssertUtil.notNull((Object)source, (String)"source must not be null");
            String jsonString = new String(source, StandardCharsets.UTF_8);
            return this.jsonConverter.readValue(jsonString, CollectedClientData.class);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public byte[] convertToBytes(@NotNull CollectedClientData source) {
        try {
            AssertUtil.notNull((Object)source, (String)"source must not be null");
            return this.jsonConverter.writeValueAsBytes(source);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    @NotNull
    public String convertToBase64UrlString(@NotNull CollectedClientData source) {
        try {
            byte[] bytes = this.convertToBytes(source);
            return Base64UrlUtil.encodeToString((byte[])bytes);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }
}

