/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MessageDigestUtil;
import java.security.MessageDigest;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MessageDigestAlgorithm {
    public static final MessageDigestAlgorithm SHA1 = new MessageDigestAlgorithm("SHA-1");
    public static final MessageDigestAlgorithm SHA256 = new MessageDigestAlgorithm("SHA-256");
    public static final MessageDigestAlgorithm SHA384 = new MessageDigestAlgorithm("SHA-384");
    public static final MessageDigestAlgorithm SHA512 = new MessageDigestAlgorithm("SHA-512");
    private final String jcaName;

    private MessageDigestAlgorithm(@NonNull String jcaName) {
        this.jcaName = jcaName;
    }

    public static @NonNull MessageDigestAlgorithm create(@NonNull String jcaName) {
        AssertUtil.notNull((Object)jcaName, (String)"jcaName must not be null");
        return new MessageDigestAlgorithm(jcaName);
    }

    @JsonCreator
    private static @NonNull MessageDigestAlgorithm deserialize(String value) throws InvalidFormatException {
        try {
            return MessageDigestAlgorithm.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, MessageDigestAlgorithm.class);
        }
    }

    @JsonValue
    public @NonNull String getJcaName() {
        return this.jcaName;
    }

    public @NonNull MessageDigest createMessageDigestObject() {
        return MessageDigestUtil.createMessageDigest((String)this.jcaName);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageDigestAlgorithm that = (MessageDigestAlgorithm)o;
        return Objects.equals(this.jcaName, that.jcaName);
    }

    public int hashCode() {
        return Objects.hash(this.jcaName);
    }

    public String toString() {
        return this.jcaName;
    }
}

