/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.webauthn4j.util.AssertUtil;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractImmutableMap<K, V>
extends AbstractMap<K, V> {
    private final HashMap<K, V> map;
    private transient Set<Map.Entry<K, V>> cachedEntrySet;

    @JsonCreator
    protected AbstractImmutableMap(@NonNull Map<K, V> map) {
        AssertUtil.notNull(map, (String)"map must not be null");
        this.map = new HashMap<K, V>(map);
    }

    @Override
    public @NonNull Set<Map.Entry<K, V>> entrySet() {
        if (this.cachedEntrySet == null) {
            this.cachedEntrySet = Collections.unmodifiableMap(this.map).entrySet();
        }
        return this.cachedEntrySet;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractImmutableMap that = (AbstractImmutableMap)o;
        return Objects.equals(this.map, that.map);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.map);
    }
}

