/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.exc.ValueInstantiationException;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JsonConverter {
    private static final String INPUT_MISMATCH_ERROR_MESSAGE = "Input data does not match expected form";
    private final ObjectMapper jsonMapper;

    JsonConverter(@NonNull ObjectMapper jsonMapper) {
        AssertUtil.notNull((Object)jsonMapper, (String)"jsonMapper must not be null");
        AssertUtil.isTrue((!(jsonMapper.getFactory() instanceof CBORFactory) ? 1 : 0) != 0, (String)"factory of jsonMapper must be JsonFactory.");
        this.jsonMapper = jsonMapper;
    }

    public <T> @Nullable T readValue(@NonNull String src, @NonNull Class<T> valueType) {
        try {
            return (T)this.jsonMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> @Nullable T readValue(@NonNull InputStream src, @NonNull Class<T> valueType) {
        try {
            return (T)this.jsonMapper.readValue(src, valueType);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> @Nullable T readValue(@NonNull String src, @NonNull TypeReference<T> valueTypeRef) {
        try {
            return (T)this.jsonMapper.readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> @Nullable T readValue(@NonNull InputStream src, @NonNull TypeReference<T> valueTypeRef) {
        try {
            return (T)this.jsonMapper.readValue(src, valueTypeRef);
        }
        catch (JsonParseException | MismatchedInputException | ValueInstantiationException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public @NonNull byte[] writeValueAsBytes(@Nullable Object value) {
        try {
            return this.jsonMapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public @NonNull String writeValueAsString(@Nullable Object value) {
        try {
            return this.jsonMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

