/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.webauthn4j.data.AuthenticatorAttachment;
import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.data.PublicKeyCredentialType;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.Base64UrlUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PublicKeyCredential<R extends AuthenticatorResponse, E extends ExtensionClientOutput>
implements Serializable {
    private final String id;
    private final byte[] rawId;
    private final R response;
    private final AuthenticatorAttachment authenticatorAttachment;
    private final AuthenticationExtensionsClientOutputs<E> clientExtensionResults;

    public PublicKeyCredential(@Nullable byte[] credentialId, @Nullable R response, @Nullable AuthenticationExtensionsClientOutputs<E> clientExtensionResults) {
        this(credentialId, response, null, clientExtensionResults);
    }

    public PublicKeyCredential(@Nullable byte[] credentialId, @Nullable R response, @Nullable AuthenticatorAttachment authenticatorAttachment, @Nullable AuthenticationExtensionsClientOutputs<E> clientExtensionResults) {
        this.id = Base64UrlUtil.encodeToString((byte[])credentialId);
        this.rawId = credentialId;
        this.response = response;
        this.authenticatorAttachment = authenticatorAttachment;
        this.clientExtensionResults = clientExtensionResults;
    }

    public @NonNull String getType() {
        return PublicKeyCredentialType.PUBLIC_KEY.getValue();
    }

    public @Nullable String getId() {
        return this.id;
    }

    public @Nullable byte[] getRawId() {
        return ArrayUtil.clone((byte[])this.rawId);
    }

    public @Nullable R getResponse() {
        return this.response;
    }

    public @Nullable AuthenticatorAttachment getAuthenticatorAttachment() {
        return this.authenticatorAttachment;
    }

    @JsonIgnore
    @Deprecated
    public @Nullable R getAuthenticatorResponse() {
        return this.response;
    }

    public @Nullable AuthenticationExtensionsClientOutputs<E> getClientExtensionResults() {
        return this.clientExtensionResults;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyCredential that = (PublicKeyCredential)o;
        return Objects.equals(this.id, that.id) && Arrays.equals(this.rawId, that.rawId) && Objects.equals(this.response, that.response) && Objects.equals(this.authenticatorAttachment, that.authenticatorAttachment) && Objects.equals(this.clientExtensionResults, that.clientExtensionResults);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.response, this.authenticatorAttachment, this.clientExtensionResults);
        result = 31 * result + Arrays.hashCode(this.rawId);
        return result;
    }

    public String toString() {
        return "PublicKeyCredential(id=" + this.id + ", response=" + this.response + ", authenticatorAttachment=" + this.authenticatorAttachment + ", clientExtensionResults=" + this.clientExtensionResults + ")";
    }
}

