/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator.attestation.trustworthiness.certpath;

import com.webauthn4j.anchor.TrustAnchorRepository;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.data.attestation.statement.FIDOU2FAttestationStatement;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.exception.CertificateException;
import com.webauthn4j.validator.exception.TrustAnchorNotFoundException;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultCertPathTrustworthinessValidator
implements CertPathTrustworthinessValidator {
    private final TrustAnchorRepository trustAnchorRepository;
    private boolean fullChainProhibited = false;
    private boolean revocationCheckEnabled = false;
    private boolean policyQualifiersRejected = false;

    public DefaultCertPathTrustworthinessValidator(TrustAnchorRepository trustAnchorRepository) {
        this.trustAnchorRepository = trustAnchorRepository;
    }

    @Override
    public void validate(@NonNull AAGUID aaguid, @NonNull CertificateBaseAttestationStatement attestationStatement, @NonNull Instant timestamp) {
        Set<TrustAnchor> trustAnchors;
        AssertUtil.notNull((Object)aaguid, (String)"aaguid must not be null");
        AssertUtil.notNull((Object)aaguid, (String)"attestationStatement must not be null");
        AssertUtil.notNull((Object)aaguid, (String)"timestamp must not be null");
        CertPath certPath = attestationStatement.getX5c().createCertPath();
        if (attestationStatement instanceof FIDOU2FAttestationStatement) {
            FIDOU2FAttestationStatement fidou2fAttestationStatement = (FIDOU2FAttestationStatement)attestationStatement;
            byte[] subjectKeyIdentifier = CertificateUtil.extractSubjectKeyIdentifier((X509Certificate)fidou2fAttestationStatement.getX5c().getEndEntityAttestationCertificate().getCertificate());
            trustAnchors = this.trustAnchorRepository.find(subjectKeyIdentifier);
        } else {
            trustAnchors = this.trustAnchorRepository.find(aaguid);
        }
        this.validateCertPath(certPath, trustAnchors, timestamp);
    }

    private TrustAnchor validateCertPath(CertPath certPath, Set<TrustAnchor> trustAnchors, Instant timestamp) {
        PKIXCertPathValidatorResult result;
        if (trustAnchors.isEmpty()) {
            throw new TrustAnchorNotFoundException("TrustAnchors are not found");
        }
        CertPathValidator certPathValidator = CertificateUtil.createCertPathValidator();
        PKIXParameters certPathParameters = CertificateUtil.createPKIXParameters(trustAnchors);
        certPathParameters.setPolicyQualifiersRejected(this.policyQualifiersRejected);
        certPathParameters.setRevocationEnabled(this.revocationCheckEnabled);
        certPathParameters.setDate(Date.from(timestamp));
        if (certPath.getCertificates().size() == 1) {
            Certificate certificate = certPath.getCertificates().get(0);
            TrustAnchor trustAnchor = trustAnchors.stream().filter(it -> it.getTrustedCert().equals(certificate)).findFirst().orElse(null);
            if (trustAnchor != null) {
                return trustAnchor;
            }
        }
        try {
            result = (PKIXCertPathValidatorResult)certPathValidator.validate(certPath, certPathParameters);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException("invalid algorithm parameter", e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException("invalid cert path", e);
        }
        if (this.fullChainProhibited && certPath.getCertificates().contains(result.getTrustAnchor().getTrustedCert())) {
            throw new CertificateException("`certpath` must not contain full chain.");
        }
        return trustAnchors.stream().filter(item -> Objects.equals(item, result.getTrustAnchor())).findFirst().orElseThrow(() -> new IllegalStateException("Matching TrustAnchor is not found."));
    }

    public boolean isFullChainProhibited() {
        return this.fullChainProhibited;
    }

    public void setFullChainProhibited(boolean fullChainProhibited) {
        this.fullChainProhibited = fullChainProhibited;
    }

    public boolean isRevocationCheckEnabled() {
        return this.revocationCheckEnabled;
    }

    public void setRevocationCheckEnabled(boolean revocationCheckEnabled) {
        this.revocationCheckEnabled = revocationCheckEnabled;
    }

    public boolean isPolicyQualifiersRejected() {
        return this.policyQualifiersRejected;
    }

    public void setPolicyQualifiersRejected(boolean policyQualifiersRejected) {
        this.policyQualifiersRejected = policyQualifiersRejected;
    }
}

