/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.AttestedCredentialDataConverter;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorResponse;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticatorAttestationResponse
extends AuthenticatorResponse {
    private final byte[] attestationObject;
    private final Set<AuthenticatorTransport> transports;

    public AuthenticatorAttestationResponse(@NonNull byte[] clientDataJSON, @NonNull byte[] attestationObject) {
        this(clientDataJSON, attestationObject, Collections.emptySet());
    }

    public AuthenticatorAttestationResponse(@NonNull byte[] clientDataJSON, @NonNull byte[] attestationObject, @Nullable Set<AuthenticatorTransport> transports) {
        super(clientDataJSON);
        AssertUtil.notNull((Object)attestationObject, (String)"attestationObject must not be null");
        this.attestationObject = attestationObject;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public @NonNull byte[] getAttestationObject() {
        return ArrayUtil.clone((byte[])this.attestationObject);
    }

    public @NonNull Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    public @NonNull byte[] getAuthenticatorData(ObjectConverter objectConverter) {
        AttestationObjectConverter attestationObjectConverter = new AttestationObjectConverter(objectConverter);
        return attestationObjectConverter.extractAuthenticatorData(this.attestationObject);
    }

    public @NonNull byte[] getAuthenticatorData() {
        return this.getAuthenticatorData(new ObjectConverter());
    }

    public @Nullable byte[] getPublicKey(ObjectConverter objectConverter) {
        return this.getCOSEKey(objectConverter).getPublicKey().getEncoded();
    }

    public @Nullable byte[] getPublicKey() {
        return this.getPublicKey(new ObjectConverter());
    }

    public @Nullable COSEAlgorithmIdentifier getPublicKeyAlgorithm(ObjectConverter objectConverter) {
        return this.getCOSEKey(objectConverter).getAlgorithm();
    }

    public @Nullable COSEAlgorithmIdentifier getPublicKeyAlgorithm() {
        return this.getCOSEKey(new ObjectConverter()).getAlgorithm();
    }

    private @NonNull COSEKey getCOSEKey(ObjectConverter objectConverter) {
        AuthenticatorDataConverter authenticatorDataConverter = new AuthenticatorDataConverter(objectConverter);
        AttestedCredentialDataConverter attestedCredentialDataConverter = new AttestedCredentialDataConverter(objectConverter);
        byte[] attestedCredentialDataBytes = authenticatorDataConverter.extractAttestedCredentialData(this.getAuthenticatorData(objectConverter));
        AttestedCredentialData attestedCredentialData = attestedCredentialDataConverter.convert(attestedCredentialDataBytes);
        return attestedCredentialData.getCOSEKey();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorAttestationResponse that = (AuthenticatorAttestationResponse)o;
        return Arrays.equals(this.attestationObject, that.attestationObject) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.transports);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        return result;
    }

    @Override
    public String toString() {
        return "AuthenticatorAttestationResponse(attestationObject=" + ArrayUtil.toHexString((byte[])this.attestationObject) + ", transports=" + this.transports + ')';
    }
}

