/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMEccCurve;
import com.webauthn4j.data.attestation.statement.TPMUPublicParms;
import com.webauthn4j.util.ArrayUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TPMSECCParms
implements TPMUPublicParms {
    private final byte[] symmetric;
    private final byte[] scheme;
    private final TPMEccCurve curveId;
    private final byte[] kdf;

    public TPMSECCParms(@NonNull byte[] symmetric, @NonNull byte[] scheme, @NonNull TPMEccCurve curveId, @NonNull byte[] kdf) {
        this.symmetric = symmetric;
        this.scheme = scheme;
        this.curveId = curveId;
        this.kdf = kdf;
    }

    public @NonNull byte[] getSymmetric() {
        return ArrayUtil.clone((byte[])this.symmetric);
    }

    public @NonNull byte[] getScheme() {
        return ArrayUtil.clone((byte[])this.scheme);
    }

    public @NonNull TPMEccCurve getCurveId() {
        return this.curveId;
    }

    public @NonNull byte[] getKdf() {
        return ArrayUtil.clone((byte[])this.kdf);
    }

    @Override
    public @Nullable byte[] getBytes() {
        return ByteBuffer.allocate(8).put(this.symmetric).put(this.scheme).put(this.curveId.getBytes()).put(this.kdf).array();
    }

    public void validate() {
        if (this.symmetric.length != 2) {
            throw new IllegalStateException("symmetric must be length 2");
        }
        if (this.scheme.length != 2) {
            throw new IllegalStateException("scheme must be length 2");
        }
        if (this.kdf.length != 2) {
            throw new IllegalStateException("kdf must be length 2");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMSECCParms that = (TPMSECCParms)o;
        return Arrays.equals(this.symmetric, that.symmetric) && Arrays.equals(this.scheme, that.scheme) && this.curveId == that.curveId && Arrays.equals(this.kdf, that.kdf);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.curveId});
        result = 31 * result + Arrays.hashCode(this.symmetric);
        result = 31 * result + Arrays.hashCode(this.scheme);
        result = 31 * result + Arrays.hashCode(this.kdf);
        return result;
    }
}

