/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import org.checkerframework.checker.nullness.qual.NonNull;

public enum CredentialProtectionPolicy {
    USER_VERIFICATION_OPTIONAL("userVerificationOptional", 1),
    USER_VERIFICATION_OPTIONAL_WITH_CREDENTIAL_ID_LIST("userVerificationOptionalWithCredentialIDList", 2),
    USER_VERIFICATION_REQUIRED("userVerificationRequired", 3);

    final String string;
    final byte value;

    private CredentialProtectionPolicy(String string2, byte value) {
        this.string = string2;
        this.value = value;
    }

    public static CredentialProtectionPolicy create(@NonNull String string) {
        switch (string) {
            case "userVerificationOptional": {
                return USER_VERIFICATION_OPTIONAL;
            }
            case "userVerificationOptionalWithCredentialIDList": {
                return USER_VERIFICATION_OPTIONAL_WITH_CREDENTIAL_ID_LIST;
            }
            case "userVerificationRequired": {
                return USER_VERIFICATION_REQUIRED;
            }
        }
        throw new IllegalArgumentException("string '" + string + "' is out of range");
    }

    public static CredentialProtectionPolicy create(byte value) {
        switch (value) {
            case 1: {
                return USER_VERIFICATION_OPTIONAL;
            }
            case 2: {
                return USER_VERIFICATION_OPTIONAL_WITH_CREDENTIAL_ID_LIST;
            }
            case 3: {
                return USER_VERIFICATION_REQUIRED;
            }
        }
        throw new IllegalArgumentException("value" + value + "' is out of range");
    }

    public @NonNull String toString() {
        return this.string;
    }

    public byte toByte() {
        return this.value;
    }
}

