/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.CollectionUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RegistrationRequest
implements Serializable {
    private final byte[] attestationObject;
    private final byte[] clientDataJSON;
    private final String clientExtensionsJSON;
    private final Set<String> transports;

    public RegistrationRequest(@Nullable byte[] attestationObject, @Nullable byte[] clientDataJSON, @Nullable String clientExtensionsJSON, @Nullable Set<String> transports) {
        this.attestationObject = ArrayUtil.clone((byte[])attestationObject);
        this.clientDataJSON = ArrayUtil.clone((byte[])clientDataJSON);
        this.clientExtensionsJSON = clientExtensionsJSON;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public RegistrationRequest(@Nullable byte[] attestationObject, @Nullable byte[] clientDataJSON, @Nullable String clientExtensionsJSON) {
        this(attestationObject, clientDataJSON, clientExtensionsJSON, null);
    }

    public RegistrationRequest(@Nullable byte[] attestationObject, @Nullable byte[] clientDataJSON, @Nullable Set<String> transports) {
        this(attestationObject, clientDataJSON, null, transports);
    }

    public RegistrationRequest(@Nullable byte[] attestationObject, @Nullable byte[] clientDataJSON) {
        this(attestationObject, clientDataJSON, null, null);
    }

    public @Nullable byte[] getAttestationObject() {
        return ArrayUtil.clone((byte[])this.attestationObject);
    }

    public @Nullable byte[] getClientDataJSON() {
        return ArrayUtil.clone((byte[])this.clientDataJSON);
    }

    public @Nullable String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    public @Nullable Set<String> getTransports() {
        return this.transports;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationRequest that = (RegistrationRequest)o;
        return Arrays.equals(this.attestationObject, that.attestationObject) && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON) && Objects.equals(this.transports, that.transports);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON, this.transports);
        result = 31 * result + Arrays.hashCode(this.attestationObject);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        return result;
    }

    public String toString() {
        return "RegistrationRequest{attestationObject=" + ArrayUtil.toHexString((byte[])this.attestationObject) + ", clientDataJSON=" + ArrayUtil.toHexString((byte[])this.clientDataJSON) + ", clientExtensionsJSON=" + this.clientExtensionsJSON + ", transports=" + this.transports + '}';
    }
}

