/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum COSEKeyType {
    OKP(1),
    EC2(2),
    RSA(3),
    SYMMETRIC(4),
    RESERVED(0);

    private final int value;

    private COSEKeyType(int value) {
        this.value = value;
    }

    public static @NonNull COSEKeyType create(int value) {
        switch (value) {
            case 1: {
                return OKP;
            }
            case 2: {
                return EC2;
            }
            case 3: {
                return RSA;
            }
            case 4: {
                return SYMMETRIC;
            }
            case 0: {
                return RESERVED;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static @NonNull COSEKeyType deserialize(int value) throws InvalidFormatException {
        try {
            return COSEKeyType.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, COSEKeyType.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }
}

