/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import java.util.Arrays;
import java.util.Objects;

public enum AuthenticatorAttestationType {
    BASIC_FULL(15879, "basic_full"),
    BASIC_SURROGATE(15880, "basic_surrogate"),
    ECDAA(15881, "ecdaa"),
    ATTCA(15882, "attca");

    private static final String VALUE_OUT_OF_RANGE_TEMPLATE = "value %s is out of range";
    private final int value;
    private final String string;

    private AuthenticatorAttestationType(int value, String string2) {
        this.value = value;
        this.string = string2;
    }

    public static AuthenticatorAttestationType create(String value) {
        return Arrays.stream(AuthenticatorAttestationType.values()).filter(item -> Objects.equals(item.string, value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public static AuthenticatorAttestationType create(int value) {
        if (value > 65535 || value < 0) {
            throw new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value));
        }
        return Arrays.stream(AuthenticatorAttestationType.values()).filter(item -> item.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.string;
    }
}

