/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.client;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.webauthn4j.converter.jackson.deserializer.CredentialProtectionPolicyStringDeserializer;
import com.webauthn4j.converter.jackson.serializer.CredentialProtectionPolicyStringSerializer;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import com.webauthn4j.data.extension.ExtensionInput;
import com.webauthn4j.data.extension.HMACGetSecretInput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.CredentialPropertiesExtensionClientInput;
import com.webauthn4j.data.extension.client.CredentialProtectionExtensionClientInput;
import com.webauthn4j.data.extension.client.ExtensionClientInput;
import com.webauthn4j.data.extension.client.FIDOAppIDExclusionExtensionClientInput;
import com.webauthn4j.data.extension.client.FIDOAppIDExtensionClientInput;
import com.webauthn4j.data.extension.client.HMACSecretAuthenticationExtensionClientInput;
import com.webauthn4j.data.extension.client.HMACSecretRegistrationExtensionClientInput;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientInput;
import com.webauthn4j.data.extension.client.UserVerificationMethodExtensionClientInput;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticationExtensionsClientInputs<T extends ExtensionClientInput>
implements Serializable {
    @JsonIgnore
    private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
    @JsonProperty
    private String appid;
    @JsonProperty
    private String appidExclude;
    @JsonProperty
    private Boolean uvm;
    @JsonProperty
    private Boolean credProps;
    @JsonSerialize(using=CredentialProtectionPolicyStringSerializer.class)
    @JsonDeserialize(using=CredentialProtectionPolicyStringDeserializer.class)
    @JsonProperty
    private CredentialProtectionPolicy credentialProtectionPolicy;
    @JsonProperty
    private Boolean enforceCredentialProtectionPolicy;
    @JsonProperty
    private Boolean hmacCreateSecret;
    @JsonProperty
    private HMACGetSecretInput hmacGetSecret;
    @JsonIgnore
    private Map<Class<? extends T>, T> extensions;

    @JsonAnyGetter
    private @NonNull Map<String, Serializable> getUnknowns() {
        return Collections.unmodifiableMap(this.unknowns);
    }

    @JsonAnySetter
    private void setUnknowns(@NonNull String name, @Nullable Serializable value) {
        this.unknowns.put(name, value);
    }

    @JsonIgnore
    public @NonNull Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.appid != null) {
            keys.add("appid");
        }
        if (this.appidExclude != null) {
            keys.add("appidExclude");
        }
        if (this.uvm != null) {
            keys.add("uvm");
        }
        if (this.credProps != null) {
            keys.add("credProps");
        }
        if (this.credentialProtectionPolicy != null) {
            keys.add("credentialProtectionPolicy");
        }
        if (this.enforceCredentialProtectionPolicy != null) {
            keys.add("enforceCredentialProtectionPolicy");
        }
        if (this.hmacCreateSecret != null) {
            keys.add("hmacCreateSecret");
        }
        if (this.hmacGetSecret != null) {
            keys.add("hmacGetSecret");
        }
        keys.addAll(this.getUnknownKeys());
        return keys;
    }

    @JsonIgnore
    public @NonNull Set<String> getUnknownKeys() {
        return this.unknowns.keySet();
    }

    @JsonIgnore
    public @Nullable Serializable getValue(@NonNull String key) {
        switch (key) {
            case "appid": {
                return this.appid;
            }
            case "appidExclude": {
                return this.appidExclude;
            }
            case "uvm": {
                return this.uvm;
            }
            case "credProps": {
                return this.credProps;
            }
            case "credentialProtectionPolicy": {
                return this.credentialProtectionPolicy;
            }
            case "enforceCredentialProtectionPolicy": {
                return this.enforceCredentialProtectionPolicy;
            }
            case "hmacCreateSecret": {
                return this.hmacCreateSecret;
            }
            case "hmacGetSecret": {
                return this.hmacGetSecret;
            }
        }
        return this.unknowns.get(key);
    }

    @JsonIgnore
    public @Nullable String getAppid() {
        return this.appid;
    }

    @JsonIgnore
    public @Nullable String getAppidExclude() {
        return this.appidExclude;
    }

    @JsonIgnore
    public @Nullable Boolean getUvm() {
        return this.uvm;
    }

    @JsonIgnore
    public @Nullable Boolean getCredProps() {
        return this.credProps;
    }

    @JsonIgnore
    public @Nullable CredentialProtectionPolicy getCredentialProtectionPolicy() {
        return this.credentialProtectionPolicy;
    }

    @JsonIgnore
    public @Nullable Boolean getEnforceCredentialProtectionPolicy() {
        return this.enforceCredentialProtectionPolicy;
    }

    @JsonIgnore
    public @Nullable Boolean getHMACCreateSecret() {
        return this.hmacCreateSecret;
    }

    @JsonIgnore
    public @Nullable HMACGetSecretInput getHMACGetSecret() {
        return this.hmacGetSecret;
    }

    public <E extends T> @Nullable E getExtension(Class<E> tClass) {
        return (E)((ExtensionClientInput)this.getExtensions().get(tClass));
    }

    @JsonIgnore
    public @NonNull Map<Class<? extends T>, T> getExtensions() {
        if (this.extensions == null) {
            HashMap<Class<HMACSecretAuthenticationExtensionClientInput>, ExtensionInput> map = new HashMap<Class<HMACSecretAuthenticationExtensionClientInput>, ExtensionInput>();
            if (this.appid != null) {
                map.put(FIDOAppIDExtensionClientInput.class, new FIDOAppIDExtensionClientInput(this.appid));
            }
            if (this.appidExclude != null) {
                map.put(FIDOAppIDExclusionExtensionClientInput.class, new FIDOAppIDExclusionExtensionClientInput(this.appidExclude));
            }
            if (this.uvm != null) {
                map.put(UserVerificationMethodExtensionClientInput.class, new UserVerificationMethodExtensionClientInput(this.uvm));
            }
            if (this.credProps != null) {
                map.put(CredentialPropertiesExtensionClientInput.class, new CredentialPropertiesExtensionClientInput(this.credProps));
            }
            if (this.credentialProtectionPolicy != null) {
                map.put(CredentialProtectionExtensionClientInput.class, new CredentialProtectionExtensionClientInput(this.credentialProtectionPolicy, this.enforceCredentialProtectionPolicy));
            }
            if (this.hmacCreateSecret != null) {
                map.put(HMACSecretRegistrationExtensionClientInput.class, new HMACSecretRegistrationExtensionClientInput(this.hmacCreateSecret));
            }
            if (this.hmacGetSecret != null) {
                map.put(HMACSecretAuthenticationExtensionClientInput.class, new HMACSecretAuthenticationExtensionClientInput(this.hmacGetSecret));
            }
            this.extensions = Collections.unmodifiableMap(map);
        }
        return this.extensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationExtensionsClientInputs that = (AuthenticationExtensionsClientInputs)o;
        return Objects.equals(this.unknowns, that.unknowns) && Objects.equals(this.appid, that.appid) && Objects.equals(this.appidExclude, that.appidExclude) && Objects.equals(this.uvm, that.uvm) && Objects.equals(this.credProps, that.credProps) && this.credentialProtectionPolicy == that.credentialProtectionPolicy && Objects.equals(this.enforceCredentialProtectionPolicy, that.enforceCredentialProtectionPolicy) && Objects.equals(this.hmacCreateSecret, that.hmacCreateSecret) && Objects.equals(this.hmacGetSecret, that.hmacGetSecret) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unknowns, this.appid, this.appidExclude, this.uvm, this.credProps, this.credentialProtectionPolicy, this.enforceCredentialProtectionPolicy, this.hmacCreateSecret, this.hmacGetSecret, this.extensions});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticationExtensionsAuthenticatorInputs(");
        String entries = this.getExtensions().values().stream().map(t -> String.format("%s=%s", t.getIdentifier(), t)).collect(Collectors.joining(", "));
        builder.append(entries);
        String unknownsStr = this.getUnknowns().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (!unknownsStr.isEmpty()) {
            builder.append(", ");
            builder.append(unknownsStr);
        }
        builder.append(")");
        return builder.toString();
    }

    public static class BuilderForAuthentication {
        private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
        private String appid;
        private String appidExclude;
        private Boolean uvm;
        private HMACGetSecretInput hmacGetSecret;

        public @NonNull AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> build() {
            AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput> instance = new AuthenticationExtensionsClientInputs<AuthenticationExtensionClientInput>();
            ((AuthenticationExtensionsClientInputs)instance).appid = this.appid;
            ((AuthenticationExtensionsClientInputs)instance).appidExclude = this.appidExclude;
            ((AuthenticationExtensionsClientInputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsClientInputs)instance).hmacGetSecret = this.hmacGetSecret;
            ((AuthenticationExtensionsClientInputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForAuthentication setAppid(@NonNull String appid) {
            this.appid = appid;
            return this;
        }

        public @NonNull BuilderForAuthentication setAppidExclude(@NonNull String appidExclude) {
            this.appidExclude = appidExclude;
            return this;
        }

        public @NonNull BuilderForAuthentication setUvm(@NonNull Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForAuthentication setHMACGetSecret(@Nullable HMACGetSecretInput hmacGetSecret) {
            this.hmacGetSecret = hmacGetSecret;
            return this;
        }

        public @NonNull BuilderForAuthentication set(@NonNull String key, @Nullable Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }

    public static class BuilderForRegistration {
        private final Map<String, Serializable> unknowns = new HashMap<String, Serializable>();
        private Boolean uvm;
        private Boolean credProps;
        private CredentialProtectionPolicy credentialProtectionPolicy;
        private Boolean enforceCredentialProtectionPolicy;
        private Boolean hmacCreateSecret;

        public @NonNull AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> build() {
            AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput> instance = new AuthenticationExtensionsClientInputs<RegistrationExtensionClientInput>();
            ((AuthenticationExtensionsClientInputs)instance).uvm = this.uvm;
            ((AuthenticationExtensionsClientInputs)instance).credProps = this.credProps;
            ((AuthenticationExtensionsClientInputs)instance).credentialProtectionPolicy = this.credentialProtectionPolicy;
            ((AuthenticationExtensionsClientInputs)instance).enforceCredentialProtectionPolicy = this.enforceCredentialProtectionPolicy;
            ((AuthenticationExtensionsClientInputs)instance).hmacCreateSecret = this.hmacCreateSecret;
            ((AuthenticationExtensionsClientInputs)instance).unknowns.putAll(this.unknowns);
            return instance;
        }

        public @NonNull BuilderForRegistration setUvm(@Nullable Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        public @NonNull BuilderForRegistration setCredProps(@Nullable Boolean credProps) {
            this.credProps = credProps;
            return this;
        }

        public @NonNull BuilderForRegistration setCredentialProtectionPolicy(@Nullable CredentialProtectionPolicy credentialProtectionPolicy) {
            this.credentialProtectionPolicy = credentialProtectionPolicy;
            return this;
        }

        public @NonNull BuilderForRegistration setEnforceCredentialProtectionPolicy(@Nullable Boolean enforceCredentialProtectionPolicy) {
            this.enforceCredentialProtectionPolicy = enforceCredentialProtectionPolicy;
            return this;
        }

        public @NonNull BuilderForRegistration setHMACCreateSecret(@Nullable Boolean hmacCreateSecret) {
            this.hmacCreateSecret = hmacCreateSecret;
            return this;
        }

        public @NonNull BuilderForRegistration set(@NonNull String key, @Nullable Serializable value) {
            AssertUtil.notNull((Object)key, (String)"key must not be null.");
            AssertUtil.notNull((Object)value, (String)"value must not be null.");
            this.unknowns.put(key, value);
            return this;
        }
    }
}

